"""
Created on 2018年4月18日
@author: 第三方
文件上传.
"""
import base64
import os
import shutil
import time
import traceback

from flask.globals import request
from H_9U.conf.syssettings import SysSettings

from H_9U.util.extract import extract_file
from H_9U.util.log import logger
from H_9U.util.fileopt import get_doc_size

# 支持的文件类型集合,集合外的不进行上传
ALLOWED_EXTENSIONS = SysSettings.AllowedFileTypeList


def _allowed_file(filename):
    """
    判断文件扩展名是否合法
    :param filename: 文件名
    :return: True or False
    """
    return filename.rsplit('.', 1)[1].lower() in ALLOWED_EXTENSIONS


def upload(file_dir, file_key, dy_name=False, filter_Chinese=False, extract=False, read_file_size=False, new_name=None,
               extract_folder='extract'):
    """
    上传文件
    :param file_dir: 上传文件目录
    :param file_key: request中文件key
    :param dy_name: 保存时是否使用动态文件名称
    :param filter_Chinese: 是否要过滤掉文件名称中的中文字符
    :param extract: 如果文件是zip格式是否自动解压
    :param read_file_size: 是否读取文件大小
    :param new_name: 保存文件使用的名称[None-不采用该新名称,使用文件自身的名称][不包含扩展名]
    :param extract_folder: 解压缩文件目录
    :return: 5个[是否成功/Boolean、文件名称、文件绝对路径、文件大小/格式化后文本-含单位、文件大小/数字型-字节]
    """
    # 保存目录不存在则创建
    if not os.path.exists(file_dir):
        os.makedirs(file_dir, mode=0o777, exist_ok=True)
        logger.debug("uploadFile创建上传路径，file_dir:%s" % file_dir)

    f = None
    try:
        # 从表单的file字段获取文件，file为该表单的name值
        f = request.files[file_key]
    except Exception as e:
        logger.exception(e)
        return False, '', '', '', '', '', ''

    # 判断是否是允许上传的文件类型
    if f and _allowed_file(f.filename):
        fname = f.filename

        # if filter_Chinese:
        #     # 文件名中的中文会被过滤掉
        #     fname = secure_filename(f.filename)

        ext = fname.rsplit('.', 1)[1]  # 获取文件后缀

        # 生成动态文件名
        if dy_name:
            unix_time = int(time.time() * 10000)
            new_file_name = str(unix_time) + '.' + ext  # 修改了上传的文件名
            to_upload_path_nm = os.path.join(file_dir, new_file_name)
        else:
            if new_name:
                new_file_name = new_name + '.' + ext
            else:
                new_file_name = fname
            new_file_name = new_file_name.replace(' ', '')
            to_upload_path_nm = os.path.join(file_dir, new_file_name)

        extract_folder_name = new_file_name.rsplit('.', 1)[0]  # 获取解压文件夹名

        # 保存新文件之前先删除旧的同名文件
        if os.path.exists(to_upload_path_nm):
            os.remove(to_upload_path_nm)

        f.save(to_upload_path_nm)  # 保存文件到upload目录

        file_size_str = '0'
        file_size = 0
        extract_to_path = None
        extract_bln = False

        # 读取文件大小
        if read_file_size:
            file_size_str, file_size = get_doc_size(to_upload_path_nm)  # 文件大小

        # 如果文件是zip格式则进行解压缩
        if extract == True:
            if extract and (ext in ['zip', 'gz']):
                extract_to_path = os.path.join(file_dir, extract_folder)  # 解压文件保存目录

                # 删除之前解压的文件
                try:
                    if os.path.exists(extract_to_path):
                        shutil.rmtree(extract_to_path)
                except Exception:
                    msg = traceback.format_exc()
                    logger.error('解压文件前删除旧的解压目录-失败:出现异常!虽不影响解压,但目录中可能会包含多余的旧文件.异常信息:%s' % msg)

                #                 # 解压缩1
                #                 z = zipfile.ZipFile(toUploadPathNm, 'r') # 加载压缩文件(不支持rar文件)
                #                 fileLst = z.namelist()  # z.namelist()返回所有文件夹和文件
                #
                #                 for zz in fileLst:
                #                     z.extract(zz, extract_to_path) # 将文件解压并保存都指定的目录下
                #                 extract_bln = True

                # 解压缩2
                extract_bln = extract_file(to_upload_path_nm, extract_to_path)

                if extract_bln == False:
                    logger.error("解压文件失败!")
            else:
                logger.error("要解压的文件类型不在处理范围之内!toUploadPathNm:%s" % to_upload_path_nm)

        # return True, new_file_name, to_upload_path_nm, file_size_str, file_size, extract_to_path, extract_folder_name
        return True, new_file_name, to_upload_path_nm, file_size_str, file_size, extract_to_path, ''
    else:
        logger.info('上传-失败：不支持该类型文件' + f.filename)
        return False, f.filename, '', '', '', '', ''


def open_upload(file_dir,file_data, file_name,  dy_name=False, extract=False, read_file_size=False, new_name=None,
               extract_folder='extract'):
    """
    上传文件
    :param file_dir: 上传文件目录
    :param dy_name: 保存时是否使用动态文件名称
    :param extract: 如果文件是zip格式是否自动解压
    :param read_file_size: 是否读取文件大小
    :param new_name: 保存文件使用的名称[None-不采用该新名称,使用文件自身的名称][不包含扩展名]
    :param extract_folder: 解压缩文件目录
    :return: 5个[是否成功/Boolean、文件名称、文件绝对路径、文件大小/格式化后文本-含单位、文件大小/数字型-字节]
    """
    # 保存目录不存在则创建
    if not os.path.exists(file_dir):
        os.makedirs(file_dir, mode=0o777, exist_ok=True)
        logger.debug("uploadFile创建上传路径，file_dir:%s" % file_dir)

    f = None
    try:
        # 解析加密的文件串
        f1 = base64.b64decode(file_data.encode('ascii'))
    except Exception as e:
        logger.exception(e)
        return False, '', '', '', '', '', ''

    # 判断是否是允许上传的文件类型
    if _allowed_file(file_name):
        fname = file_name
        ext = fname.rsplit('.', 1)[1]  # 获取文件后缀
        # 生成动态文件名
        if dy_name:
            unix_time = int(time.time() * 10000)
            new_file_name = str(unix_time) + '.' + ext  # 修改了上传的文件名
            to_upload_path_nm = os.path.join(file_dir, new_file_name)
        else:
            if new_name:
                new_file_name = new_name + '.' + ext
            else:
                new_file_name = fname
            new_file_name = new_file_name.replace(' ', '')
            to_upload_path_nm = os.path.join(file_dir, new_file_name)
        # # 保存新文件之前先删除旧的同名文件
        # if os.path.exists(to_upload_path_nm):
        #     os.remove(to_upload_path_nm)

        with open(to_upload_path_nm, 'wb') as f2:
         f2.write(f1)
        print('success')
        # f.save(to_upload_path_nm)  # 保存文件到upload目录

        file_size_str = '0'
        file_size = 0
        extract_to_path = None
        extract_bln = False

        # 读取文件大小
        if read_file_size:
            file_size_str, file_size = get_doc_size(to_upload_path_nm)  # 文件大小

        # 如果文件是zip格式则进行解压缩
        if extract == True:
            if extract and (ext in ['zip', 'gz']):
                extract_to_path = os.path.join(file_dir, extract_folder)  # 解压文件保存目录

                # 删除之前解压的文件
                try:
                    if os.path.exists(extract_to_path):
                        shutil.rmtree(extract_to_path)
                except Exception:
                    msg = traceback.format_exc()
                    logger.error('解压文件前删除旧的解压目录-失败:出现异常!虽不影响解压,但目录中可能会包含多余的旧文件.异常信息:%s' % msg)

                #                 # 解压缩1
                #                 z = zipfile.ZipFile(toUploadPathNm, 'r') # 加载压缩文件(不支持rar文件)
                #                 fileLst = z.namelist()  # z.namelist()返回所有文件夹和文件
                #
                #                 for zz in fileLst:
                #                     z.extract(zz, extract_to_path) # 将文件解压并保存都指定的目录下
                #                 extract_bln = True

                # 解压缩2
                extract_bln = extract_file(to_upload_path_nm, extract_to_path)

                if extract_bln == False:
                    logger.error("解压文件失败!")
            else:
                logger.error("要解压的文件类型不在处理范围之内!toUploadPathNm:%s" % to_upload_path_nm)

        # return True, new_file_name, to_upload_path_nm, file_size_str, file_size, extract_to_path, extract_folder_name
        return True, new_file_name, to_upload_path_nm, file_size_str, file_size, extract_to_path, ''
    else:
        logger.info('上传-失败：不支持该类型文件' + file_name)
        return False, file_name, '', '', '', '', ''