import re
import math

veSaTiming = [
    # /* Interlaced modes. */
    ['XVIDC_VM_720x480_60_I', "720x480@60Hz (I)", 'XVIDC_FR_60HZ',
     [720, 19, 62, 57, 858, 0,
      240, 4, 3, 15, 262, 5, 3, 15, 263, 0]],
    ['XVIDC_VM_720x576_50_I', "720x576@50Hz (I)", 'XVIDC_FR_50HZ',
     [720, 12, 63, 69, 864, 0,
      288, 2, 3, 19, 312, 3, 3, 19, 313, 0]],
    ['XVIDC_VM_1440x480_60_I', "1440x480@60Hz (I)", 'XVIDC_FR_60HZ',
     [1440, 38, 124, 114, 1716, 0,
      240, 4, 3, 15, 262, 5, 3, 15, 263, 0]],
    ['XVIDC_VM_1440x576_50_I', "1440x576@50Hz (I)", 'XVIDC_FR_50HZ',
     [1440, 24, 126, 138, 1728, 0,
      288, 2, 3, 19, 312, 3, 3, 19, 313, 0]],
    ['XVIDC_VM_1920x1080_48_I', "1920x1080@48Hz (I)", 'XVIDC_FR_48HZ',
     [1920, 371, 88, 371, 2750, 1,
      540, 2, 5, 15, 562, 3, 5, 15, 563, 1]],
    ['XVIDC_VM_1920x1080_50_I', "1920x1080@50Hz (I)", 'XVIDC_FR_50HZ',
     [1920, 528, 44, 148, 2640, 1,
      540, 2, 5, 15, 562, 3, 5, 15, 563, 1]],
    ['XVIDC_VM_1920x1080_60_I', "1920x1080@60Hz (I)", 'XVIDC_FR_60HZ',
     [1920, 88, 44, 148, 2200, 1,
      540, 2, 5, 15, 562, 3, 5, 15, 563, 1]],
    ['XVIDC_VM_1920x1080_96_I', "1920x1080@96Hz (I)", 'XVIDC_FR_96HZ',
     [1920, 371, 88, 371, 2750, 1,
      1080, 4, 10, 30, 1124, 6, 10, 30, 1126, 1]],
    ['XVIDC_VM_1920x1080_100_I', "1920x1080@100Hz (I)", 'XVIDC_FR_100HZ',
     [1920, 528, 44, 148, 2640, 1,
      1080, 4, 10, 30, 1124, 6, 10, 30, 1126, 1]],
    ['XVIDC_VM_1920x1080_120_I', "1920x1080@120Hz (I)", 'XVIDC_FR_120HZ',
     [1920, 88, 44, 148, 2200, 1,
      1080, 4, 10, 30, 1124, 6, 10, 30, 1126, 1]],
    ['XVIDC_VM_2048x1080_48_I', "2048x1080@48Hz (I)", 'XVIDC_FR_48HZ',
     [2048, 329, 44, 329, 2750, 1,
      540, 2, 5, 15, 562, 3, 5, 15, 563, 1]],
    ['XVIDC_VM_2048x1080_50_I', "2048x1080@50Hz (I)", 'XVIDC_FR_50HZ',
     [2048, 274, 44, 274, 2640, 1,
      540, 2, 5, 15, 562, 3, 5, 15, 563, 1]],
    ['XVIDC_VM_2048x1080_60_I', "2048x1080@60Hz (I)", 'XVIDC_FR_60HZ',
     [2048, 66, 20, 66, 2200, 1,
      540, 2, 5, 15, 562, 3, 5, 15, 563, 1]],
    ['XVIDC_VM_2048x1080_96_I', "2048x1080@96Hz (I)", 'XVIDC_FR_96HZ',
     [2048, 329, 44, 329, 2750, 1,
      1080, 4, 10, 30, 1124, 6, 10, 30, 1126, 1]],
    ['XVIDC_VM_2048x1080_100_I', "2048x1080@100Hz (I)", 'XVIDC_FR_100HZ',
     [2048, 274, 44, 274, 2640, 1,
      1080, 4, 10, 30, 1124, 6, 10, 30, 1126, 1]],
    ['XVIDC_VM_2048x1080_120_I', "2048x1080@120Hz (I)", 'XVIDC_FR_120HZ',
     [2048, 66, 20, 66, 2200, 1,
      1080, 4, 10, 30, 1124, 6, 10, 30, 1126, 1]],
    # /* Progressive modes. */
    ['XVIDC_VM_640x350_85_P', "640x350@85Hz", 'XVIDC_FR_85HZ',
     [640, 32, 64, 96, 832, 1,
      350, 32, 3, 60, 445, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_640x480_60_P', "640x480@60Hz", 'XVIDC_FR_60HZ',
     [640, 8 + 8, 96, 40 + 8, 800, 0,
      480, 2 + 8, 2, 25 + 8, 525, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_640x480_72_P', "640x480@72Hz", 'XVIDC_FR_72HZ',
     [640, 8 + 16, 40, 120 + 8, 832, 0,
      480, 8 + 1, 3, 20 + 8, 520, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_640x480_75_P', "640x480@75Hz", 'XVIDC_FR_75HZ',
     [640, 16, 64, 120, 840, 0,
      480, 1, 3, 16, 500, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_640x480_85_P', "640x480@85Hz", 'XVIDC_FR_85HZ',
     [640, 56, 56, 80, 832, 0,
      480, 1, 3, 25, 509, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_720x400_85_P', "720x400@85Hz", 'XVIDC_FR_85HZ',
     [720, 36, 72, 108, 936, 0,
      400, 1, 3, 42, 446, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_720x480_60_P', "720x480@60Hz", 'XVIDC_FR_60HZ',
     [720, 16, 62, 60, 858, 0,
      480, 9, 6, 30, 525, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_720x576_50_P', "720x576@50Hz", 'XVIDC_FR_50HZ',
     [720, 12, 64, 68, 864, 0,
      576, 5, 5, 39, 625, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_800x600_56_P', "800x600@56Hz", 'XVIDC_FR_56HZ',
     [800, 24, 72, 128, 1024, 1,
      600, 1, 2, 22, 625, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_800x600_60_P', "800x600@60Hz", 'XVIDC_FR_60HZ',
     [800, 40, 128, 88, 1056, 1,
      600, 1, 4, 23, 628, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_800x600_72_P', "800x600@72Hz", 'XVIDC_FR_72HZ',
     [800, 56, 120, 64, 1040, 1,
      600, 37, 6, 23, 666, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_800x600_75_P', "800x600@75Hz", 'XVIDC_FR_75HZ',
     [800, 16, 80, 160, 1056, 1,
      600, 1, 3, 21, 625, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_800x600_85_P', "800x600@85Hz", 'XVIDC_FR_85HZ',
     [800, 32, 64, 152, 1048, 1,
      600, 1, 3, 27, 631, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_800x600_120_P_RB', "800x600@120Hz (RB)", 'XVIDC_FR_120HZ',
     [800, 48, 32, 80, 960, 1,
      600, 3, 4, 29, 636, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_848x480_60_P', "848x480@60Hz", 'XVIDC_FR_60HZ',
     [848, 16, 112, 112, 1088, 1,
      480, 6, 8, 23, 517, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1024x768_60_P', "1024x768@60Hz", 'XVIDC_FR_60HZ',
     [1024, 24, 136, 160, 1344, 0,
      768, 3, 6, 29, 806, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1024x768_70_P', "1024x768@70Hz", 'XVIDC_FR_70HZ',
     [1024, 24, 136, 144, 1328, 0,
      768, 3, 6, 29, 806, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1024x768_75_P', "1024x768@75Hz", 'XVIDC_FR_75HZ',
     [1024, 16, 96, 176, 1312, 1,
      768, 1, 3, 28, 800, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1024x768_85_P', "1024x768@85Hz", 'XVIDC_FR_85HZ',
     [1024, 48, 96, 208, 1376, 1,
      768, 1, 3, 36, 808, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1024x768_120_P_RB', "1024x768@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1024, 48, 32, 80, 1184, 1,
      768, 3, 4, 38, 813, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1152x864_75_P', "1152x864@75Hz", 'XVIDC_FR_75HZ',
     [1152, 64, 128, 256, 1600, 1,
      864, 1, 3, 32, 900, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x720_24_P', "1280x720@24Hz", 'XVIDC_FR_24HZ',
     [1280, 1760, 40, 220, 3300, 1,
      720, 5, 5, 20, 750, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x720_25_P', "1280x720@25Hz", 'XVIDC_FR_25HZ',
     [1280, 2420, 40, 220, 3960, 1,
      720, 5, 5, 20, 750, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x720_30_P', "1280x720@30Hz", 'XVIDC_FR_30HZ',
     [1280, 1760, 40, 220, 3300, 1,
      720, 5, 5, 20, 750, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x720_50_P', "1280x720@50Hz", 'XVIDC_FR_50HZ',
     [1280, 440, 40, 220, 1980, 1,
      720, 5, 5, 20, 750, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x720_60_P', "1280x720@60Hz", 'XVIDC_FR_60HZ',
     [1280, 110, 40, 220, 1650, 1,
      720, 5, 5, 20, 750, 0, 0, 0, 0, 1]],
    # /*[ XVIDC_VM_1280x768_60_P, "1280x768@60Hz", XVIDC_FR_60HZ,
    # 		[1280, 64, 128, 192, 1664, 0,
    # 		768, 3, 7, 20, 798, 0, 0, 0, 0, 1] ],*/
    ['XVIDC_VM_1280x768_60_P_RB', "1280x768@60Hz (RB)", 'XVIDC_FR_60HZ',
     [1280, 48, 32, 80, 1440, 1,
      768, 3, 7, 12, 790, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1280x768_75_P', "1280x768@75Hz", 'XVIDC_FR_75HZ',
     [1280, 80, 128, 208, 1696, 0,
      768, 3, 7, 27, 805, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x768_85_P', "1280x768@85Hz", 'XVIDC_FR_85HZ',
     [1280, 80, 136, 216, 1712, 0,
      768, 3, 7, 31, 809, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x768_120_P_RB', "1280x768@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1280, 48, 32, 80, 1440, 1,
      768, 3, 7, 35, 813, 0, 0, 0, 0, 0]],
    # /*[ XVIDC_VM_1280x800_60_P, "1280x800@60Hz", XVIDC_FR_60HZ,
    # 		[1280, 72, 128, 200, 1680, 0,
    # 		800, 3, 6, 22, 831, 0, 0, 0, 0, 1] ],*/
    ['XVIDC_VM_1280x800_60_P_RB', "1280x800@60Hz (RB)", 'XVIDC_FR_60HZ',
     [1280, 48, 32, 80, 1440, 1,
      800, 3, 6, 14, 823, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1280x800_75_P', "1280x800@75Hz", 'XVIDC_FR_75HZ',
     [1280, 80, 128, 208, 1696, 0,
      800, 3, 6, 29, 838, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x800_85_P', "1280x800@85Hz", 'XVIDC_FR_85HZ',
     [1280, 80, 136, 216, 1712, 0,
      800, 3, 6, 34, 843, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x800_120_P_RB', "1280x800@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1280, 48, 32, 80, 1440, 1,
      800, 3, 6, 38, 847, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1280x960_60_P', "1280x960@60Hz", 'XVIDC_FR_60HZ',
     [1280, 96, 112, 312, 1800, 1,
      960, 1, 3, 36, 1000, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x960_85_P', "1280x960@85Hz", 'XVIDC_FR_85HZ',
     [1280, 64, 160, 224, 1728, 1,
      960, 1, 3, 47, 1011, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x960_120_P_RB', "1280x960@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1280, 48, 32, 80, 1440, 1,
      960, 3, 4, 50, 1017, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1280x1024_60_P', "1280x1024@60Hz", 'XVIDC_FR_60HZ',
     [1280, 48, 112, 248, 1688, 1,
      1024, 1, 3, 38, 1066, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x1024_75_P', "1280x1024@75Hz", 'XVIDC_FR_75HZ',
     [1280, 16, 144, 248, 1688, 1,
      1024, 1, 3, 38, 1066, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x1024_85_P', "1280x1024@85Hz", 'XVIDC_FR_85HZ',
     [1280, 64, 160, 224, 1728, 1,
      1024, 1, 3, 44, 1072, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1280x1024_120_P_RB', "1280x1024@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1280, 48, 32, 80, 1440, 1,
      1024, 3, 7, 50, 1084, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1360x768_60_P', "1360x768@60Hz", 'XVIDC_FR_60HZ',
     [1360, 64, 112, 256, 1792, 1,
      768, 3, 6, 18, 795, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1360x768_120_P_RB', "1360x768@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1360, 48, 32, 80, 1520, 1,
      768, 3, 5, 37, 813, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1366x768_60_P', "1366x768@60Hz", 'XVIDC_FR_60HZ',
     [1366, 70, 143, 213, 1792, 1,
      768, 3, 3, 24, 798, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1366x768_60_P_RB', "1366x768@60Hz (RB)", 'XVIDC_FR_60HZ',
     [1366, 14, 56, 64, 1500, 1,
      768, 1, 3, 28, 800, 0, 0, 0, 0, 1]],
    # /*[ XVIDC_VM_1400x1050_60_P, "1400x1050@60Hz", XVIDC_FR_60HZ,
    # 		[1400, 88, 144, 232, 1864, 0,
    # 		1050, 3, 4, 32, 1089, 0, 0, 0, 0, 1] ],*/
    ['XVIDC_VM_1400x1050_60_P_RB', "1400x1050@60Hz (RB)", 'XVIDC_FR_60HZ',
     [1400, 48, 32, 80, 1560, 1,
      1050, 3, 4, 23, 1080, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1400x1050_75_P', "1400x1050@75Hz", 'XVIDC_FR_75HZ',
     [1400, 104, 144, 248, 1896, 0,
      1050, 3, 4, 42, 1099, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1400x1050_85_P', "1400x1050@85Hz", 'XVIDC_FR_85HZ',
     [1400, 104, 152, 256, 1912, 0,
      1050, 3, 4, 48, 1105, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1400x1050_120_P_RB', "1400x1050@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1400, 48, 32, 80, 1560, 1,
      1050, 3, 4, 55, 1112, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1440x240_60_P', "1440x240@60Hz", 'XVIDC_FR_60HZ',
     [1440, 38, 124, 114, 1716, 0,
      240, 14, 3, 4, 262, 0, 0, 0, 0, 1]],
    # /*[ XVIDC_VM_1440x900_60_P, "1440x900@60Hz", XVIDC_FR_60HZ,
    # 		[1440, 80, 152, 232, 1904, 0,
    # 		900, 3, 6, 25, 934, 0, 0, 0, 0, 1] ],*/
    ['XVIDC_VM_1440x900_60_P_RB', "1440x900@60Hz (RB)", 'XVIDC_FR_60HZ',
     [1440, 48, 32, 80, 1600, 1,
      900, 3, 6, 17, 926, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1440x900_75_P', "1440x900@75Hz", 'XVIDC_FR_75HZ',
     [1440, 96, 152, 248, 1936, 0,
      900, 3, 6, 33, 942, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1440x900_85_P', "1440x900@85Hz", 'XVIDC_FR_85HZ',
     [1440, 104, 152, 256, 1952, 0,
      900, 3, 6, 39, 948, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1440x900_120_P_RB', "1440x900@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1440, 48, 32, 80, 1600, 1,
      900, 3, 6, 44, 953, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1600x1200_60_P', "1600x1200@60Hz", 'XVIDC_FR_60HZ',
     [1600, 64, 192, 304, 2160, 1,
      1200, 1, 3, 46, 1250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1600x1200_65_P', "1600x1200@65Hz", 'XVIDC_FR_65HZ',
     [1600, 64, 192, 304, 2160, 1,
      1200, 1, 3, 46, 1250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1600x1200_70_P', "1600x1200@70Hz", 'XVIDC_FR_70HZ',
     [1600, 64, 192, 304, 2160, 1,
      1200, 1, 3, 46, 1250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1600x1200_75_P', "1600x1200@75Hz", 'XVIDC_FR_75HZ',
     [1600, 64, 192, 304, 2160, 1,
      1200, 1, 3, 46, 1250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1600x1200_85_P', "1600x1200@85Hz", 'XVIDC_FR_85HZ',
     [1600, 64, 192, 304, 2160, 1,
      1200, 1, 3, 46, 1250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1600x1200_120_P_RB', "1600x1200@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1600, 48, 32, 80, 1760, 1,
      1200, 3, 4, 64, 1271, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1680x720_50_P', "1680x720@50Hz", 'XVIDC_FR_50HZ',
     [1680, 260, 40, 220, 2200, 1,
      720, 5, 5, 20, 750, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1680x720_60_P', "1680x720@60Hz", 'XVIDC_FR_60HZ',
     [1680, 260, 40, 220, 2200, 1,
      720, 5, 5, 20, 750, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1680x720_100_P', "1680x720@100Hz", 'XVIDC_FR_100HZ',
     [1680, 60, 40, 220, 2000, 1,
      720, 5, 5, 95, 825, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1680x720_120_P', "1680x720@120Hz", 'XVIDC_FR_120HZ',
     [1680, 60, 40, 220, 2000, 1,
      720, 5, 5, 95, 825, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1680x1050_50_P', "1680x1050@50Hz", 'XVIDC_FR_50HZ',
     [1680, 88, 176, 264, 2208, 0,
      1050, 3, 6, 24, 1083, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1680x1050_60_P', "1680x1050@60Hz", 'XVIDC_FR_60HZ',
     [1680, 104, 176, 280, 2240, 0,
      1050, 3, 6, 30, 1089, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1680x1050_60_P_RB', "1680x1050@60Hz (RB)", 'XVIDC_FR_60HZ',
     [1680, 48, 32, 80, 1840, 1,
      1050, 3, 6, 21, 1080, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1680x1050_75_P', "1680x1050@75Hz", 'XVIDC_FR_75HZ',
     [1680, 120, 176, 296, 2272, 0,
      1050, 3, 6, 40, 1099, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1680x1050_85_P', "1680x1050@85Hz", 'XVIDC_FR_85HZ',
     [1680, 128, 176, 304, 2288, 0,
      1050, 3, 6, 46, 1105, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1680x1050_120_P_RB', "1680x1050@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1680, 48, 32, 80, 1840, 1,
      1050, 3, 6, 53, 1112, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1792x1344_60_P', "1792x1344@60Hz", 'XVIDC_FR_60HZ',
     [1792, 128, 200, 328, 2448, 0,
      1344, 1, 3, 46, 1394, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1792x1344_75_P', "1792x1344@75Hz", 'XVIDC_FR_75HZ',
     [1792, 96, 216, 352, 2456, 0,
      1344, 1, 3, 69, 1417, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1792x1344_120_P_RB', "1792x1344@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1792, 48, 32, 80, 1952, 1,
      1344, 3, 4, 72, 1423, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1856x1392_60_P', "1856x1392@60Hz", 'XVIDC_FR_60HZ',
     [1856, 96, 224, 352, 2528, 0,
      1392, 1, 3, 43, 1439, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1856x1392_75_P', "1856x1392@75Hz", 'XVIDC_FR_75HZ',
     [1856, 128, 224, 352, 2560, 0,
      1392, 1, 3, 104, 1500, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1856x1392_120_P_RB', "1856x1392@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1856, 48, 32, 80, 2016, 1,
      1392, 3, 4, 75, 1474, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1920x1080_24_P', "1920x1080@24Hz", 'XVIDC_FR_24HZ',
     [1920, 638, 44, 148, 2750, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1920x1080_25_P', "1920x1080@25Hz", 'XVIDC_FR_25HZ',
     [1920, 528, 44, 148, 2640, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1920x1080_30_P', "1920x1080@30Hz", 'XVIDC_FR_30HZ',
     [1920, 88, 44, 148, 2200, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1920x1080_48_P', "1920x1080@48Hz", 'XVIDC_FR_48HZ',
     [1920, 638, 44, 148, 2750, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1920x1080_50_P', "1920x1080@50Hz", 'XVIDC_FR_50HZ',
     [1920, 528, 44, 148, 2640, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1920x1080_60_P', "1920x1080@60Hz", 'XVIDC_FR_60HZ',
     [1920, 88, 44, 148, 2200, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1920x1080_100_P', "1920x1080@100Hz", 'XVIDC_FR_100HZ',
     [1920, 528, 44, 148, 2640, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1920x1080_120_P', "1920x1080@120Hz", 'XVIDC_FR_120HZ',
     [1920, 88, 44, 148, 2200, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    # /*[ XVIDC_VM_1920x1200_60_P, "1920x1200@60Hz", XVIDC_FR_60HZ,
    # 		[1920, 136, 200, 336, 2592, 0,
    # 		1200, 3, 6, 36, 1245, 0, 0, 0, 0, 1] ],*/
    ['XVIDC_VM_1920x1200_60_P_RB', "1920x1200@60Hz (RB)", 'XVIDC_FR_60HZ',
     [1920, 48, 32, 80, 2080, 1,
      1200, 3, 6, 26, 1235, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1920x1200_75_P', "1920x1200@75Hz", 'XVIDC_FR_75HZ',
     [1920, 136, 208, 344, 2608, 0,
      1200, 3, 6, 46, 1255, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1920x1200_85_P', "1920x1200@85Hz", 'XVIDC_FR_85HZ',
     [1920, 144, 208, 352, 2624, 0,
      1200, 3, 6, 53, 1262, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1920x1200_120_P_RB', "1920x1200@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1920, 48, 32, 80, 2080, 1,
      1200, 3, 6, 62, 1271, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1920x1440_60_P', "1920x1440@60Hz", 'XVIDC_FR_60HZ',
     [1920, 128, 208, 344, 2600, 0,
      1440, 1, 3, 56, 1500, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1920x1440_75_P', "1920x1440@75Hz", 'XVIDC_FR_75HZ',
     [1920, 144, 224, 352, 2640, 0,
      1440, 1, 3, 56, 1500, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_1920x1440_120_P_RB', "1920x1440@120Hz (RB)", 'XVIDC_FR_120HZ',
     [1920, 48, 32, 80, 2080, 1,
      1440, 3, 4, 78, 1525, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_1920x2160_60_P', "1920x2160@60Hz", 'XVIDC_FR_60HZ',
     [1920, 88, 44, 148, 2200, 1,
      2160, 20, 10, 60, 2250, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_2048x1080_24_P', "2048x1080@24Hz", 'XVIDC_FR_24HZ',
     [2048, 510, 44, 148, 2750, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_2048x1080_25_P', "2048x1080@25Hz", 'XVIDC_FR_25HZ',
     [2048, 400, 44, 148, 2640, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_2048x1080_30_P', "2048x1080@30Hz", 'XVIDC_FR_30HZ',
     [2048, 66, 20, 66, 2200, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_2048x1080_48_P', "2048x1080@48Hz", 'XVIDC_FR_48HZ',
     [2048, 510, 44, 148, 2750, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_2048x1080_50_P', "2048x1080@50Hz", 'XVIDC_FR_50HZ',
     [2048, 400, 44, 148, 2640, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_2048x1080_60_P', "2048x1080@60Hz", 'XVIDC_FR_60HZ',
     [2048, 88, 44, 20, 2200, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_2048x1080_100_P', "2048x1080@100Hz", 'XVIDC_FR_100HZ',
     [2048, 528, 44, 148, 2640, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_2048x1080_120_P', "2048x1080@120Hz", 'XVIDC_FR_120HZ',
     [2048, 88, 44, 148, 2200, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_2560x1080_50_P', "2560x1080@50Hz", 'XVIDC_FR_50HZ',
     [2560, 548, 44, 148, 3300, 1,
      1080, 4, 5, 36, 1125, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_2560x1080_60_P', "2560x1080@60Hz", 'XVIDC_FR_60HZ',
     [2560, 248, 44, 148, 3000, 1,
      1080, 4, 5, 11, 1100, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_2560x1080_100_P', "2560x1080@100Hz", 'XVIDC_FR_100HZ',
     [2560, 218, 44, 148, 2970, 1,
      1080, 4, 5, 161, 1250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_2560x1080_120_P', "2560x1080@120Hz", 'XVIDC_FR_120HZ',
     [2560, 548, 44, 148, 3300, 1,
      1080, 4, 5, 161, 1250, 0, 0, 0, 0, 1]],
    # /*[ XVIDC_VM_2560x1600_60_P, "2560x1600@60Hz", XVIDC_FR_60HZ,
    # 		[2560, 192, 280, 472, 3504, 0,
    # 		1600, 3, 6, 49, 1658, 0, 0, 0, 0, 1] ],*/
    ['XVIDC_VM_2560x1600_60_P_RB', "2560x1600@60Hz (RB)", 'XVIDC_FR_60HZ',
     [2560, 48, 32, 80, 2720, 1,
      1600, 3, 6, 37, 1646, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_2560x1600_75_P', "2560x1600@75Hz", 'XVIDC_FR_75HZ',
     [2560, 208, 280, 488, 3536, 0,
      1600, 3, 6, 63, 1672, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_2560x1600_85_P', "2560x1600@85Hz", 'XVIDC_FR_85HZ',
     [2560, 208, 280, 488, 3536, 0,
      1600, 3, 6, 73, 1682, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_2560x1600_120_P_RB', "2560x1600@120Hz (RB)", 'XVIDC_FR_120HZ',
     [2560, 48, 32, 80, 2720, 1,
      1600, 3, 6, 85, 1694, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_3840x2160_24_P', "3840x2160@24Hz", 'XVIDC_FR_24HZ',
     [3840, 1276, 88, 296, 5500, 1,
      2160, 8, 10, 72, 2250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_3840x2160_25_P', "3840x2160@25Hz", 'XVIDC_FR_25HZ',
     [3840, 1056, 88, 296, 5280, 1,
      2160, 8, 10, 72, 2250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_3840x2160_30_P', "3840x2160@30Hz", 'XVIDC_FR_30HZ',
     [3840, 176, 88, 296, 4400, 1,
      2160, 8, 10, 72, 2250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_3840x2160_48_P', "3840x2160@48Hz", 'XVIDC_FR_48HZ',
     [3840, 1276, 88, 296, 5500, 1,
      2160, 8, 10, 72, 2250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_3840x2160_50_P', "3840x2160@50Hz", 'XVIDC_FR_50HZ',
     [3840, 1056, 88, 296, 5280, 1,
      2160, 8, 10, 72, 2250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_3840x2160_60_P', "3840x2160@60Hz", 'XVIDC_FR_60HZ',
     [3840, 176, 88, 296, 4400, 1,
      2160, 8, 10, 72, 2250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_3840x2160_60_P_RB', "3840x2160@60Hz (RB)", 'XVIDC_FR_60HZ',
     [3840, 48, 32, 80, 4000, 1,
      2160, 3, 5, 54, 2222, 0, 0, 0, 0, 0]],
    ['XVIDC_VM_4096x2160_24_P', "4096x2160@24Hz", 'XVIDC_FR_24HZ',
     [4096, 1020, 88, 296, 5500, 1,
      2160, 8, 10, 72, 2250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_4096x2160_25_P', "4096x2160@25Hz", 'XVIDC_FR_25HZ',
     [4096, 968, 88, 128, 5280, 1,
      2160, 8, 10, 72, 2250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_4096x2160_30_P', "4096x2160@30Hz", 'XVIDC_FR_30HZ',
     [4096, 88, 88, 128, 4400, 1,
      2160, 8, 10, 72, 2250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_4096x2160_48_P', "4096x2160@48Hz", 'XVIDC_FR_48HZ',
     [4096, 1020, 88, 296, 5500, 1,
      2160, 8, 10, 72, 2250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_4096x2160_50_P', "4096x2160@50Hz", 'XVIDC_FR_50HZ',
     [4096, 968, 88, 128, 5280, 1,
      2160, 8, 10, 72, 2250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_4096x2160_60_P', "4096x2160@60Hz", 'XVIDC_FR_60HZ',
     [4096, 88, 88, 128, 4400, 1,
      2160, 8, 10, 72, 2250, 0, 0, 0, 0, 1]],
    ['XVIDC_VM_4096x2160_60_P_RB', "4096x2160@60Hz (RB)", 'XVIDC_FR_60HZ',
     [4096, 8, 32, 40, 4176, 1,
      2160, 48, 8, 6, 2222, 0, 0, 0, 0, 0]]
]

def _checkVesa(width, height, RefreshRate, maxBandwidth, s='P'):
    """
    根据水平宽度、垂直高度、刷新率重新获取timing参数值，有可能获取到为null
    :param width: 水平宽度 （分辨率中的宽度）
    :param height: 垂直高度（分辨率中的高度）
    :param RefreshRate: 刷新率
    :param maxBandwidth:
    :param s:
    :return: timing参数 / null
    """
    pattern = 'XVIDC_VM_{}x{}_{}_{}'.format(width, height, RefreshRate, s)

    reg = re.compile(pattern, re.I)
    arr = list(filter(lambda el:  reg.match(el[0]), veSaTiming))
    if not arr:
        s = 'P_RB'
        pattern = 'XVIDC_VM_{}x{}_{}_{}'.format(width, height, RefreshRate, s)
        reg = re.compile(pattern, re.I)
        arr = list(filter(lambda el: reg.match(el[0]), veSaTiming))
    if arr:
        HActive, HFrontPorch, HSyncWidth, HBackPorch, HTotal, HSyncPolarity, VActive, VFrontPorch, VSyncWidth, \
        VBackPorch, VTotal, F1VFrontPorch, F1VSyncWidth, F1VBackPorch, F1VTotal, VSyncPolarity = arr[0][3]  # , PixClkx100\
        if maxBandwidth and HTotal * VTotal * RefreshRate > maxBandwidth:
            return None
            # if s == 'P':
            #     return _checkVesa(width, height, RefreshRate, maxBandwidth, s='P_RB')
            # else:
            #     return None
        HSyncPolarity = 1 - HSyncPolarity
        VSyncPolarity = 1 - VSyncPolarity
        return {
            'HActive': HActive,
            'HFrontPorch': HFrontPorch,
            'HSyncWidth': HSyncWidth,
            'HBackPorch': HBackPorch,
            'HTotal': HTotal,
            'HSyncPolarity': HSyncPolarity,
            'VActive': VActive,
            'VFrontPorch': VFrontPorch,
            'VSyncWidth': VSyncWidth,
            'VBackPorch': VBackPorch,
            'VTotal': VTotal,
            'VSyncPolarity': VSyncPolarity,
            # 'PixClkx100':PixClkx100,
            'F1VFrontPorch': F1VFrontPorch,
            'F1VSyncWidth': F1VSyncWidth,
            'F1VBackPorch': F1VBackPorch,
            'F1VTotal': F1VTotal,
            'RefreshRate': RefreshRate
        }


# // These are CVT 1.1 default timings, the global variables are
# // changed below if we need to use CVT 1.2 timings.

CLOCK_STEP = 0.001  #0.250; // Clock steps in MHz
MARGIN_PERCENT = 1.800  # % of active vertical image
H_SYNC_PER = 8.000  # sync % of horizontal image
CELL_GRAN = 1.000  #8.000; // assumed character cell granularity
CELL_GRAN_RND = 1.000  #8.000; // assumed character cell granularity (round)
MIN_V_BPORCH = 3.000  #6.000; // width of vsync in lines
MIN_V_PORCH_RND = 3.000  # width of vsync in lines
M = 600.000  # blanking formula gradient
C = 40.000  # blanking formula offset
K = 128.000  # blanking formula scaling factor
J = 20.000  # blanking formula scaling factor
# // Standard Timing Parameters
MIN_VSYNC_BP = 550.000  # min time of vsync + back porch (us)
H_SYNC_PERCENT = 8.000  # width of hsync as % of total line
# // Reduced Blanking defines
RB_MIN_V_BPORCH = 6.000  # lines
RB_V_FPORCH = 3.000  # 23.000  #3.000; // linesXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
RB_MIN_V_BLANK = 460.000  # us
RB_H_SYNC = 32.000  # pixels
RB_H_BLANK = 160.000  # pixels  #
# // C' and M' are part of the Blanking Duty Cycle computation.
C_PRIME = ((C - J) * K) / 256.0 + J
M_PRIME = (M * K / 256.0)


def _vertRefresh (h_pixels,  v_lines,  freq,  interlaced=0,  reduced_blank = 1,  margins = 0,  film_optimized = 0):
    """
    根据水平宽度、垂直高度、刷新率重新获取timing参数值
    :param h_pixels: 水平宽度 （分辨率中的宽度）
    :param v_lines: 垂直高度（分辨率中的高度）
    :param freq:  刷新率
    :param interlaced:
    :param reduced_blank:
    :param margins:
    :param film_optimized:
    :return:  timing对象
    """
    # h_pixels_rnd
    # v_lines_rnd
    # v_field_rate_rqd
    # top_margin
    # bot_margin
    # interlace
    # h_period_est
    # v_sync_bp
    # left_margin
    # right_margin
    # total_active_pixels
    # ideal_duty_cycle
    # cur_duty_cycle
    # v_sync
    # h_blank
    # total_pixels
    # total_v_lines
    # v_sync_rnd
    # h_sync_rnd
    # h_back_porch
    # v_front_porch
    # h_front_porch
    # vbi_lines
    # act_vbi_lines
    # rb_min_vbi
    # act_pixel_freq
    # act_h_freq
    # aspect_ratio
    # stage
    act_field_rate = 0
    act_frame_rate = 0
    global_verbose = 0
    m = {}
    '''
       /*  1. Required Field Rate
       *
       *  This is slightly different from the spreadsheet because we use
       *  a different result for interlaced video modes.  Simplifies this
       *  to the input field rate.
       *
       *  [V FIELD RATE RQD] = [I/P FREQ RQD]
       */
    '''
    v_field_rate_rqd = freq
    # //print_value(1, "[V FIELD RATE RQD]", v_field_rate_rqd);
    '''
      /*  2. Horizontal Pixels
       *
       *  In order to give correct results, the number of horizontal
       *  pixels requested is first processed to ensure that it is divisible
       *  by the character size, by rounding it to the nearest character
       *  cell boundary.
       *
       *  [H PIXELS RND] = ((ROUNDDOWN([H PIXELS]/[CELL GRAN RND],0))
       *       *[CELLGRAN RND])
       */
    '''

    h_pixels_rnd = math.floor(h_pixels / CELL_GRAN_RND) * CELL_GRAN_RND
    # //print_value(2, "[H PIXELS RND]", h_pixels_rnd);
    '''
      /*  2.5th Calculation, aspect_ratio & v_sync_rnd
       *
       *  [ASPECT_RATIO] = IF(H_PIXELS_RND = CELL_GRAN_RND*ROUND((V_LINES*
       *     4.0/3.0)/CELL_GRAN_RND),"4:3")
       *     etc...
       *  [V_SYNC] = [value from table based on aspect ratio]
       *  [V_SYNC_RND] = ROUND(V_SYNC,0)  // Not needed in principle
       */
    '''

    if (h_pixels_rnd == CELL_GRAN_RND * math.floor((v_lines * 4.0 / 3.0) / CELL_GRAN_RND)):
        aspect_ratio = "4:3"
        v_sync = 4
    elif (h_pixels_rnd == CELL_GRAN_RND * math.floor((v_lines * 16.0 / 9.0) / CELL_GRAN_RND)):
        aspect_ratio = "16:9"
        v_sync = 5
    elif (h_pixels_rnd == CELL_GRAN_RND * math.floor((v_lines * 16.0 / 10.0) / CELL_GRAN_RND)):
        aspect_ratio = "16:10"
        v_sync = 6
    elif (h_pixels_rnd == CELL_GRAN_RND * math.floor((v_lines * 5.0 / 4.0) / CELL_GRAN_RND)):
        aspect_ratio = "5:4"
        v_sync = 7
    elif (h_pixels_rnd == CELL_GRAN_RND * math.floor((v_lines * 15.0 / 9.0) / CELL_GRAN_RND)):
        aspect_ratio = "15:9"
        v_sync = 7
    else:
        # // Default case of unknown aspect ratio.
        aspect_ratio = "Custom"
        v_sync = 10

    v_sync_rnd = v_sync

    if global_verbose:
        pass
        # //    printf(
        # //      " 2.5: [ASPECT_RATIO]           : %10s\n"
        # //      " 2.5: [V SYNC]                 : %15f\n",
        # //      aspect_ratio,
        # //      v_sync_rnd
        # //    );
    '''
        /*
       *  3. Determine Left & Right Borders
       *
       *  Calculate the margins on the left and right side.
             *
       *  [LEFT MARGIN (PIXELS)] = (IF( [MARGINS RQD?]="Y",
       *          (ROUNDDOWN( ([H PIXELS RND] * [MARGIN%] / 100 /
       *                   [CELL GRAN RND]),0)) * [CELL GRAN RND],
       *          0))
       *  [RIGHT MARGIN (PIXELS)] = (IF( [MARGINS RQD?]="Y",
       *          (ROUNDDOWN( ([H PIXELS RND] * [MARGIN%] / 100 /
       *                   [CELL GRAN RND]),0)) * [CELL GRAN RND],
       *          0))
       */
    '''
    left_margin = math.floor(h_pixels_rnd * MARGIN_PERCENT / 100.0 / CELL_GRAN_RND) * CELL_GRAN_RND if margins else 0.0
    right_margin = left_margin
    # //print_value(3, "[LEFT MARGIN (PIXELS)]", left_margin);
    # //print_value(3, "[RIGHT MARGIN (PIXELS)]", right_margin);
    '''
    /*  4. Find total active pixels.
       *
       *  Find total number of active pixels in image and left and right
       *  margins.
       *
       *  [TOTAL ACTIVE PIXELS] = [H PIXELS RND] + [LEFT MARGIN (PIXELS)] +
       *                          [RIGHT MARGIN (PIXELS)]
       */
    '''
    total_active_pixels = float(h_pixels_rnd) + float(left_margin) + float(right_margin)
    # //print_value(4, "[TOTAL ACTIVE PIXELS]", total_active_pixels);
    '''
    /*  5. Find number of lines per field.
   *
   *  If interlace is requested, the number of vertical lines assumed
   *  by the calculation must be halved, as the computation calculates
   *  the number of vertical lines per field. In either case, the
   *  number of lines is rounded to the nearest integer.
   *
   *  [V LINES RND] = IF([INT RQD?]="y", ROUNDDOWN([V LINES]/2,0),
   *                                     ROUNDDOWN([V LINES],0))
   */
   '''
    v_lines_rnd = math.floor(v_lines / 2.0) if interlaced else math.floor(v_lines)
    # //print_value(5, "[V LINES RND]", v_lines_rnd);

    '''
    /*  6. Find Top and Bottom margins.
   *
   *  [TOP MARGIN (LINES)] = IF([MARGINS RQD?]="Y",
   *          ROUNDDOWN(([MARGIN%]/100*[V LINES RND]),0),
   *          0)
   *  [BOT MARGIN (LINES)] = IF([MARGINS RQD?]="Y",
   *          ROUNDDOWN(([MARGIN%]/100*[V LINES RND]),0),
   *          0)
   */
    '''
    top_margin = math.floor(MARGIN_PERCENT / 100.0 * v_lines_rnd) if margins else (0.0)
    bot_margin = top_margin;
    # //print_value(6, "[TOP MARGIN (LINES)]", top_margin);
    # //print_value(6, "[BOT MARGIN (LINES)]", bot_margin);
    '''
      /*  7. If interlace is required, then set variable [INTERLACE]=0.5:
       *
       *  [INTERLACE]=(IF([INT RQD?]="y",0.5,0))
       */
    '''
    interlace = 0.5 if interlaced else 0.0
    # //print_value(7, "[INTERLACE]", interlace);

    # /*
    #  *  Here it diverges for "reduced blanking" or normal blanking modes.
    #  */

    if (reduced_blank):
        h_blank = RB_H_BLANK
        '''
        /*  8. Estimate Horiz. Period (us).
        *
        *  [H PERIOD EST] = ((1000000/V_FIELD_RATE_RQD)-RB_MIN_V_BLANK)/(V_LINES_RND+TOP_MARGIN+BOT_MARGIN)
        */
        '''

        h_period_est = (1000000.0 / v_field_rate_rqd - RB_MIN_V_BLANK) / (float(v_lines_rnd) + float(top_margin) + float(bot_margin))
        # //print_value(8, "[H PERIOD EST]", h_period_est);

        '''
        /*  9. Find number of lines in vertical blanking.
        *
        *  [Actual VBI_LINES] = RB_MIN_V_BLANK/H_PERIOD_EST
        *  [VBI_LINES] = ROUNDDOWN(RB_MIN_V_BLANK/H_PERIOD_EST,0) + 1
        */
        '''

        vbi_lines = RB_MIN_V_BLANK / h_period_est
        # //print_value(9, "[Actual VBI LINES]", vbi_lines);

        vbi_lines = math.floor(vbi_lines) + 1.0
        # //print_value(9, "[VBI LINES]", vbi_lines);

        '''
        /*  10. Check Vertical Blanking is sufficient.
        *
        *  [RB MIN VBI] = RB_V_FPORCH+V_SYNC_RND+RB_MIN_V_BPORCH
        *  [ACT VBI LINES] = IF(VBI_LINES<RB_MIN_VBI,RB_MIN_VBI,VBI_LINES)
        */
        '''
        rb_min_vbi = RB_V_FPORCH + v_sync_rnd + RB_MIN_V_BPORCH
        act_vbi_lines = rb_min_vbi if (vbi_lines < rb_min_vbi) else vbi_lines
        # //print_value(10, "[Minimum VBI Lines]", rb_min_vbi);
        # //print_value(10, "[ACT VBI LINES]", act_vbi_lines);

        '''
        /*  11. Find total number of lines in vertical field.
        *
        *  [TOTAL V LINES] = ACT_VBI_LINES+V_LINES_RND+TOP_MARGIN+BOT_MARGIN+INTERLACE
        */
        '''
        total_v_lines = float(act_vbi_lines) + float(v_lines_rnd) + float(top_margin) + float(bot_margin) + float(interlace)
        # //print_value(11, "[TOTAL V LINES]", total_v_lines);

        '''
        /*  12. Find total number of pixels in a line (pixels).
        *
        *  [TOTAL PIXELS] = RB_H_BLANK+TOTAL_ACTIVE_PIXELS
        */
        '''
        total_pixels = float(total_active_pixels) + float(RB_H_BLANK)
        # //print_value(12, "[TOTAL PIXELS]", total_pixels);

        '''
        /*  13. Find Pixel Clock Frequency (MHz).
        *
        *  [Non-rounded PIXEL_FREQ] = V_FIELD_RATE_RQD*TOTAL_V_LINES*TOTAL_PIXELS/1000000
        *  [ACT PIXEL FREQ] = CLOCK_STEP * ROUND((V_FIELD_RATE_RQD*TOTAL_V_LINES*TOTAL_PIXELS/1000000)/CLOCK_STEP,0)
        */
        '''
        act_pixel_freq = v_field_rate_rqd * total_v_lines * total_pixels / 1000000.0
        # //print_value(13, "[Non-rounded PIXEL FREQ]", act_pixel_freq);

        act_pixel_freq = CLOCK_STEP * math.floor(act_pixel_freq / CLOCK_STEP)
        # //print_value(13, "[ACT PIXEL FREQ]", act_pixel_freq);

        # // Lower pixel clock to get the vertical refresh rate to match video better.
        # // ie (24 * 1000 / 1001) = 23.976
        if (film_optimized == 1):
            act_pixel_freq = (act_pixel_freq * 1000 / 1001)

        stage = 14

    else:
        '''
        /*  8. Estimate Horiz. Period (us).
        *
        *  [H PERIOD EST] = ((1/V_FIELD_RATE_RQD)-MIN_VSYNC_BP/1000000)/(V_LINES_RND+(2*TOP_MARGIN)+MIN_V_PORCH_RND+INTERLACE)*1000000
        */
        '''
        h_period_est = ((1 / v_field_rate_rqd) - MIN_VSYNC_BP / 1000000.0) / (float(v_lines_rnd) + float(2 * top_margin) + float(MIN_V_PORCH_RND) + float(interlace)) * 1000000.0
        # //print_value(8, "[H PERIOD EST]", h_period_est);

        '''
        /*  9. Find number of lines in (SYNC + BACK PORCH).
        *
        *  [Estimated V_SYNC_BP] = ROUNDDOWN((MIN_VSYNC_BP/H_PERIOD_EST),0)+1
        *  [Actual V_SYNC_BP] = MIN_VSYNC_BP/H_PERIOD_EST
        *  [V_SYNC_BP] = IF(Estimated V_SYNC_BP<(V_SYNC+MIN_V_BPORCH),
        *       V_SYNC+MIN_V_BPORCH,Estimated V_SYNC_BP)
        */
        '''
        v_sync_bp = MIN_VSYNC_BP / h_period_est
        # //print_value(9, "[Actual V_SYNC_BP]", v_sync_bp);
    
        v_sync_bp = math.floor(v_sync_bp) + 1
        # //print_value(9, "[Estimated V_SYNC_BP]", v_sync_bp);
    
        v_sync_bp = float(v_sync) + float(MIN_V_BPORCH) if (v_sync_bp < float(v_sync) + float(MIN_V_BPORCH)) else float(v_sync_bp)
        # //print_value(9, "[V_SYNC_BP]", v_sync_bp);

        '''
        /*  10. Find number of lines in back porch (Lines).
        *
        *  [Back porch] = V_SYNC_BP - V_SYNC_RND;
        */
        //print_value(10, "[Back porch]", v_sync_bp - v_sync_rnd);
        '''

        '''
        /*  11. Find total number of lines in vertical field.
        *
        *  [TOTAL V LINES] = V_LINES_RND+TOP_MARGIN+BOT_MARGIN
        *      +V_SYNC_BP+INTERLACE+MIN_V_PORCH_RND
        */
        '''
        total_v_lines = float(v_lines_rnd) + float(top_margin) + float(bot_margin) + float(v_sync_bp) + float(interlace) + float(MIN_V_PORCH_RND)
        # //print_value(11, "[TOTAL V LINES]", total_v_lines);

        '''
        /*  12. Find ideal blanking duty cycle from formula (%):
        *
        *  [IDEAL DUTY CYCLE] = C_PRIME-(M_PRIME*H_PERIOD_EST/1000)
        */
        '''
        ideal_duty_cycle = C_PRIME - (M_PRIME * h_period_est / 1000.0);
        # //print_value(12, "[IDEAL DUTY CYCLE]", ideal_duty_cycle);

        '''
        /*  13. Find blanking time to nearest cell (Pixels).
        *
        *  [H BLANK] = IF(IDEAL_DUTY_CYCLE<20,(ROUNDDOWN((TOTAL_ACTIVE_PIXELS*20/(100-20)/(2*CELL_GRAN_RND)),0))*(2*CELL_GRAN_RND),(ROUNDDOWN((TOTAL_ACTIVE_PIXELS*IDEAL_DUTY_CYCLE/(100-IDEAL_DUTY_CYCLE)/(2*CELL_GRAN_RND)),0))*(2*CELL_GRAN_RND))
        */
        '''
        cur_duty_cycle = 20.0 if (ideal_duty_cycle < 20.0) else ideal_duty_cycle
        h_blank = math.floor((total_active_pixels * cur_duty_cycle / (100.0 - cur_duty_cycle) / (2.0 * CELL_GRAN_RND))) * (2.0 * CELL_GRAN_RND)
        # //print_value(13, "[H BLANK]", h_blank);

        '''
        /*  14. Find total number of pixels in a line (Pixels).
        *
        *  [TOTAL PIXELS] = TOTAL_ACTIVE_PIXELS + H_BLANK
        */
        '''
        total_pixels = float(total_active_pixels) + float(h_blank);
        # //print_value(14, "[TOTAL PIXELS]", total_pixels);

        '''
        /*  15. Find pixel clock frequency (MHz).
        *
        *  [Non-rounded PIXEL FREQ] = TOTAL_PIXELS / H_PERIOD_EST
        *  [ACT PIXEL FREQ] = CLOCK_STEP * ROUNDDOWN(
        */
        '''
        act_pixel_freq = total_pixels / h_period_est
        # //print_value(15, "[Non-rounded PIXEL FREQ]", act_pixel_freq);
        act_pixel_freq = CLOCK_STEP * math.floor(act_pixel_freq / CLOCK_STEP)
        # //print_value(15, "[ACT PIXEL FREQ]", act_pixel_freq);
    
        stage = 16

    '''    
    /*  14/16. Find actual horizontal frequency (kHz)
    *
    *  [ACT H FREQ] = 1000*ACT_PIXEL_FREQ/TOTAL_PIXELS
    */
    '''
    act_h_freq = 1000 * act_pixel_freq / total_pixels
    # //print_value(stage, "[ACT H FREQ]", act_h_freq);
    stage += 1

    '''
      /*  15/17. Find actual field rate (Hz)
       *
       *  [ACT FIELD RATE] = 1000*ACT_H_FREQ/TOTAL_V_LINES
       */
    '''
    act_field_rate = 1000 * act_h_freq / total_v_lines
    # //print_value(stage, "[ACT FIELD RATE]", act_field_rate);
    stage += 1

    '''
      /*  16/18. Find actual vertical frame frequency (Hz)
       *
       *  [ACT FRAME RATE] = IF(INT_RQD?=Y,ACT_FIELD_RATE/2,ACT_FIELD_RATE)
       */
    '''

    act_frame_rate = (act_field_rate / 2) if interlace else act_field_rate
    # //print_value(stage, "[ACT FRAME RATE]", act_frame_rate);
    #
    # // Extra computations not numbered in the CVT spreadsheet.

    '''
      /*  20. Find Horizontal Back Porch.
       *
       *  [H BACK PORCH] = H_BLANK/2
       */
   '''
    h_back_porch = h_blank / 2
    # //print_value(20, "[H BACK PORCH]", h_back_porch);

    '''
      /*  21. Find Horizontal Front Porch.
       *
       *  [H SYNC RND] = IF(RED_BLANK_RQD?="Y",RB_H_SYNC,(ROUNDDOWN((H_SYNC_PER/100*TOTAL_PIXELS/CELL_GRAN_RND),0))*CELL_GRAN_RND)
       */
    '''
    if (reduced_blank):
        h_sync_rnd = RB_H_SYNC
    else:
        h_sync_rnd = math.floor(H_SYNC_PER / 100.0 * total_pixels / CELL_GRAN_RND) * CELL_GRAN_RND


    # //print_value(21, "[H SYNC RND]", h_sync_rnd);

    '''
      /*  22. Find Horizontal Front Porch.
       *
       *  [H FRONT PORCH] = H_BLANK - H_BACK_PORCH - H_SYNC_RND
       */
    '''
    h_front_porch = h_blank - h_back_porch - h_sync_rnd
    # //print_value(22, "[H FRONT PORCH]", h_front_porch)

    '''
      /*  23. Find Vertical Front Porch.
       *
       *  [V FRONT PORCH] = IF(RED_BLANK_RQD?="y",RB_V_FPORCH,MIN_V_PORCH_RND)
       */
    '''

    v_front_porch = RB_V_FPORCH if reduced_blank else MIN_V_PORCH_RND
    # //print_value(23, "[V FRONT PORCH]", v_front_porch);

    # // Finally, pack the results in the let struct.

    m['hr']  = float(h_pixels_rnd)
    m['hss'] = float(h_pixels_rnd) + float(h_front_porch)
    m['hse'] = float(h_pixels_rnd) + float(h_front_porch) + float(h_sync_rnd)
    m['hfl'] = float(total_pixels)

    m['HActive'] = float(h_pixels_rnd)
    m['HFrontPorch'] = float(h_front_porch)
    m['HSyncWidth'] = float(h_sync_rnd)
    m['HTotal'] = float(total_pixels)
    m['HSyncPolarity'] =  1  # // 默认取值 为负

    real_v_lines = float(v_lines)
    m['vr']  = float(real_v_lines)
    m['vss'] = float(real_v_lines) + float(v_front_porch)
    m['vse'] = float(real_v_lines) + float(v_front_porch) + float(v_sync_rnd)
    m['vfl'] = float(total_v_lines) - float(v_lines_rnd) + float(real_v_lines)

    m['VActive'] = float(real_v_lines)
    m['VFrontPorch'] = float(v_front_porch)
    m['VSyncWidth'] = float(v_sync_rnd)
    m['VTotal'] = float(total_v_lines) - float(v_lines_rnd) + float(real_v_lines)
    m['VSyncPolarity'] = 0  # // 默认取值 为负

    m['RefreshRate'] = freq

    m['pclk']   = act_pixel_freq
    m['h_freq'] = act_h_freq
    m['v_freq'] = freq
    m['real_v_rate'] = act_field_rate

    m['in_new'] = interlaced
    m['rb'] = reduced_blank
    return m


def outputResolution(width, height, refresh, maxBandWidth):
    """
    判断当前分辨率是否超出带宽，未超出则下发参数调接口，超出则重置为之前正确的值
    :param device_id: 设备Id
    :param outputIds:  output id list
    :param width: 宽度
    :param height:  高度
    :param refresh: 刷新率
    :return:
    """
    standardTiming = _checkVesa(width, height, refresh, maxBandWidth)
    if (not standardTiming):
        standardTiming = _vertRefresh(width, height, refresh)

    if standardTiming:
        if (float(standardTiming['HTotal']) * float(standardTiming['VTotal']) * float(refresh) <= maxBandWidth):
            # this.setTiming(standardTiming); // 未超出最大带宽，下发参数调接口
            standardTiming = {
                "refreshRate": refresh,
                "horizontal":
                    {
                        "addrTime": standardTiming['HActive'],
                        "frontPorch": standardTiming['HFrontPorch'],
                        "sync": standardTiming['HSyncWidth'],
                        "syncPolarity": standardTiming['HSyncPolarity'],
                        "totalTime": standardTiming['HTotal']
                    },
                "vertical":
                    {
                        "addrTime": standardTiming['VActive'],
                        "frontPorch": standardTiming['VFrontPorch'],
                        "sync": standardTiming['VSyncWidth'],
                        "syncPolarity": standardTiming['VSyncPolarity'],
                        "totalTime": standardTiming['VTotal']
                    }
            }
        else:
            standardTiming = None

    return standardTiming


def outputCustomResolution(width, height, refresh, max_band):
    """
    水平总数 ：h_total
    水平有效 ：h_active
    水平前肩 ：h_front_porch
    水平后肩 ：h_back_porch
    水平同步宽度 ： h_sync

    垂直总数 ：v_total
    垂直有效 ：v_active
    垂直前肩 ：v_front_porch
    垂直后肩 ：v_back_porch
    垂直同步宽度 ： v_sync

    帧率        ： vs_freq

    v_front_porch = 3
    v_back_porch = 3
    v_sync = 2
    v_total = v_active + v_front_porch + v_back_porch + v_sync


    h_total  =  (165000000/vs_freq/v_total)向下对2取整
    M1 = h_total - h_active  = h_front_porch + h_back_porch + h_sync
    M2 = (h_active * 4%)向下对2取整   须满足M1 >= M2
    h_front_porch  = (M1/3 )向下对2取整= a
    h_back_porch = (M1/3)向下对2取整 = b
    h_sync = M1 - a - b
    """
    vs_freq = refresh
    v_active = height
    v_front_porch = 3
    v_back_porch = 3
    v_sync = 2
    v_total = v_active + v_front_porch + v_back_porch + v_sync

    h_total = int(max_band / vs_freq / v_total // 2 * 2)
    h_active = width
    M1 = h_total - h_active
    M2 = int(h_active * 0.04 // 2 * 2)
    if M1 >= M2:
        h_front_porch = a = h_back_porch = b = int(M1 / 3 // 2 * 2)
        h_sync = M1 - a - b

        standard_timing = {
            "refreshRate": refresh,
            "horizontal":
                {
                    "addrTime": h_active,
                    "frontPorch": h_front_porch,
                    "sync": h_sync,
                    "syncPolarity": 0,
                    "totalTime": h_total
                },
            "vertical":
                {
                    "addrTime": v_active,
                    "frontPorch": v_front_porch,
                    "sync": v_sync,
                    "syncPolarity": 0,
                    "totalTime": v_total
                }
        }
        if float(standard_timing['horizontal']['totalTime']) * \
                float(standard_timing['vertical']['totalTime']) * \
                float(refresh) <= max_band:
            return standard_timing
    else:
        return None

def outputFourFiberCustomResolution(width, height, refresh, max_band):
    """
    水平总数 ：h_total
    水平有效 ：h_active
    水平前肩 ：h_front_porch
    水平后肩 ：h_back_porch
    水平同步宽度 ： h_sync

    垂直总数 ：v_total
    垂直有效 ：v_active
    垂直前肩 ：v_front_porch
    垂直后肩 ：v_back_porch
    垂直同步宽度 ： v_sync

    帧率        ： vs_freq

    v_front_porch = 3
    v_back_porch = 3
    v_sync = 2
    v_total = v_active + v_front_porch + v_back_porch + v_sync


    h_total  =  (165000000/vs_freq/v_total)向下对2取整
    M1 = h_total - h_active  = h_front_porch + h_back_porch + h_sync
    M2 = (h_active * 4%)向下对2取整   须满足M1 >= M2
    h_front_porch  = (M1/3 )向下对2取整= a
    h_back_porch = (M1/3)向下对2取整 = b
    h_sync = M1 - a - b
    """
    vs_freq = refresh
    v_active = height
    v_front_porch = 3
    v_back_porch = 10
    v_sync = 2
    v_total = v_active + v_front_porch + v_back_porch + v_sync

    h_total = int(max_band / vs_freq / v_total // 2 * 2)
    h_active = width
    M1 = h_total - h_active
    M2 = int(h_active * 0.04 // 2 * 2)
    if M1 >= M2:
        h_front_porch = a = h_back_porch = b = int(M1 / 3 // 2 * 2)
        h_sync = M1 - a - b

        standard_timing = {
            "refreshRate": refresh,
            "horizontal":
                {
                    "addrTime": h_active,
                    "frontPorch": h_front_porch,
                    "sync": h_sync,
                    "syncPolarity": 0,
                    "totalTime": h_total
                },
            "vertical":
                {
                    "addrTime": v_active,
                    "frontPorch": v_front_porch,
                    "sync": v_sync,
                    "syncPolarity": 0,
                    "totalTime": v_total
                }
        }
        if float(standard_timing['horizontal']['totalTime']) * \
                float(standard_timing['vertical']['totalTime']) * \
                float(refresh) <= max_band:
            return standard_timing
    else:
        return None


if __name__ == '__main__':
    pass