"""
Created on 2022年3月28日
@author: 程声清
数据过滤服务
"""

from H_9U.api.filter.filter import _filter_input_list_group_data, \
    _filter_input_group_data, _filter_input_data, _filter_screen_list_data, _filter_screen_data, _filter_output_data, \
    _filter_role_data, _filter_user_data
from H_9U.models.syncdataname import SyncDataName
from H_9U.util.common import format_token
from H_9U.service.user import usersvc
from H_9U.service.role import rolesvc


def data_filter(data_message, client_token):
    """
    推送数据过滤
    :param data_message: 推送数据
    :param client_token: 客户端信息
    :return: 数据
    """
    if client_token != "" and data_message:
        # 替换验证webToken的当前信息
        token = format_token(client_token)
        user_rs = usersvc.build_user_data(token)
        if user_rs['status'] != 0:
            return user_rs
        role_id = user_rs['data']['roleId']
        role_type = user_rs['data']['roleType']
        filter_data = user_rs['data']['filterData']
        # 获取推送的名称以及数据
        push_name = data_message['name']
        push_data = data_message['data']

        if push_name in [SyncDataName.Input_Group_Node_Delete,
                         SyncDataName.Input_IPC_Montage_Save]:
            data_message['data'] = _filter_input_list_group_data(role_type, filter_data['inputList'], push_data)

        elif push_name == SyncDataName.Input_Group_Data:
            data_message['data'] = _filter_input_group_data(
                role_type, filter_data['inputList'], push_data)

        elif push_name == SyncDataName.Device_Write_IPCMode:
            data_message['data'] = _filter_input_data(
                role_type, filter_data['inputList'], push_data)

        elif push_name in [SyncDataName.Screen_Read_All_List,
                           SyncDataName.Output_Timing_Changed,
                           SyncDataName.Screen_Clear_data]:
            data_message['data'] = _filter_screen_list_data(role_type, filter_data['screenList'], push_data)

        elif push_name in [SyncDataName.Screen_Delete,
                           SyncDataName.Screen_Create,
                           SyncDataName.Screen_Write_General,
                           SyncDataName.Screen_Write_Freeze,
                           SyncDataName.Screen_Write_BKG,
                           SyncDataName.Screen_Write_OSD,
                           SyncDataName.Screen_Write_Output_Mode,
                           SyncDataName.Screen_Write_TestPattern,
                           SyncDataName.Screen_Write_ImageQuality,
                           SyncDataName.Screen_Write_Gamma,
                           SyncDataName.Screen_Brightness,
                           SyncDataName.Screen_Write_HDR,
                           SyncDataName.Screen_Write_3D,
                           SyncDataName.Screen_Write_Phase_Offset,
                           SyncDataName.Layer_Create,
                           SyncDataName.Layer_Delete,
                           SyncDataName.Layer_Delete_All,
                           SyncDataName.Layer_Write_General,
                           SyncDataName.Layer_Write_Window,
                           SyncDataName.Layer_Write_Source,
                           SyncDataName.Layer_Write_Z_Index,
                           SyncDataName.Layer_Write_Lock,
                           SyncDataName.Layer_Screen_Take,
                           SyncDataName.Layer_Freeze,
                           SyncDataName.Layer_Screen_Layout,
                           SyncDataName.Layer_Write_Z_Index,
                           SyncDataName.Preset_Add,
                           SyncDataName.Preset_Over_Write,
                           SyncDataName.Preset_Delete,
                           SyncDataName.Preset_Group_List,
                           SyncDataName.Preset_Read_List,
                           SyncDataName.Preset_Write_General,
                           SyncDataName.Preset_Play,
                           SyncDataName.Preset_Poll]:
            data_message['data'] = _filter_screen_data(role_type, filter_data['screenList'], push_data)
        elif push_name == SyncDataName.Output_Read_List:
            data_message['data'] = _filter_output_data(role_type, filter_data['outputList'], push_data)

        # role 角色删除不过滤数据
        elif push_name in [SyncDataName.Role_Add,
                           SyncDataName.Role_Update]:
            rs = rolesvc.get_role_message(role_id)
            data_message['data'] = _filter_role_data(role_type, rs['data'], push_data)

        # user 用户删除不过滤数据
        elif push_name in [SyncDataName.User_Add,
                           SyncDataName.User_Update]:
            rs = usersvc.get_user_by_role_id(role_id)
            data_message['data'] = _filter_user_data(role_type, rs['data'], push_data)
        return data_message
    else:
        return None

