'''
Created on 2019年5月5日
@author: GongQingBao
队列：先入先出(FIFO)
'''

# Queue(self)         # 创建空队列
# is_empty(self)      # 判断队列是否为空
# add(self, elem) # 将元素elem加入队列
# delete(self)       # 删除队列中最先加入的元素并将其返回
# peek(self)          # 取得队列中最早进入的元素，不删除


# 循环顺序表实现队列,头部删除和查看O(1),尾部加入O(1)
class SQueue(object):
    def __init__(self, init_num=5, extand_bln=False):
        self._len = init_num    # 存储区长度
        self._elems = [None] * init_num
        self._head = 0          # 表头元素下标
        self._num = 0           # 元素个数
        self.extand = extand_bln    # 当队列慢时是否自动扩容

    def is_empty(self):
        return self._num == 0

    def peek(self):
        if self.is_empty():
            return None
        return self._elems[self._head]

    def delete(self):
        if self.is_empty():
            return None
        result = self._elems[self._head]
        self._head = (self._head + 1) % self._len
        self._num -= 1
        return result

    def add(self, elem):
        if self._num == self._len:
            if self.extand:
                self.__extand()
            else:
                self.delete()
        self._elems[(self._head + self._num) % self._len] = elem
        self._num += 1

    def __extand(self):     # 当入队的时候如果 list长度不够，动态增加2倍
        old_len = self._len
        self._len *= 2
        new_elems = [0] * self._len
        for i in range(old_len):
            new_elems[i] = self._elems[(self._head + i) % old_len]
        self._elems, self._head = new_elems, 0

    def getAll(self):
        rs = [];
        for i in range(self._num):
            rs.append(self._elems[(self._head + i) % self._len])
        return rs;

if __name__ == "__main__":
    q = SQueue()
    for i in range(100):
        q.add(i)
    # for i in range(8):
    #    print(q.delete())
    # print(q._num)
#     q.add(5)
#     q.add(6)
#     print(q._head)
#     print(q._num)
#     print(q._elems)


        