"""
Created on 2021年9月13日
@author: 程声清
screen业务处理层.
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
import time

from H_9U.mao.screen_mao import screen_api
from H_9U.util.log import logger
from H_9U.models.sysconst import ModelId
from H_9U.service.middlewarefilepath import screen_osd_manager


def screen_create_middle(device_id, params):
    """
    创建单个Screen. 参数不含screenId
    :param device_id: 设备Id
    :param params: 创建屏幕参数
    :return: 屏幕Id
    """
    return screen_api.write_create(device_id, params)


def screen_delete_middle(device_id, screen_id, data):
    """
    删除屏幕
    :param device_id: 设备Id
    :param screen_id:  屏幕Id
    :param data: 删除屏幕参数
    :return: 结果数据
    """
    return screen_api.write_delete(device_id, screen_id, data)


def read_detail_middle(device_id, screen_id):
    """
    读取屏幕详情
    :param device_id: 设备id
    :param screen_id: 屏幕id
    :return:
    """
    return screen_api.read_detail(device_id, screen_id)


def read_screen_brightness_middle(device_id, screen_id):
    """
    读取屏幕亮度
    :param device_id: 设备id
    :param screen_id: 屏幕id
    :return: 结果对象
    """
    return screen_api.read_screen_brightness(device_id, screen_id)


def read_list_middle(device_id):
    """
    读取列表
    :param device_id: 设备id
    :return: 统一结果
    """
    return screen_api.read_list(device_id)


def screen_read_list_middle(device_id):
    """
    读取列表
    :param device_id: 设备id
    :return: 统一结果
    """
    rs = screen_api.read_list(device_id)
    # if rs["status"] == 0:
    #     if rs['data']:
    #         screens = rs['data'].get("screens", None)
    #         screen_arr = []
    #         for screen in screens:
    #             screen_list = {}
    #             screen_list['deviceId'] = device_id
    #             screen_list['screenId'] = screen["screenId"]
    #             screen_arr.append(screen_list)
    #         rs['data'] = screen_arr
    return rs

def screen_rename_middle(device_id, screen_id, data):
    """
      设置基本信息
      :param : JSON对象参数
      :param device_id: 设备Id
      :param screen_id:  屏幕Id
      :param data: 数据
      :return: 结果对象
      """
    return  screen_api.write_general(device_id, screen_id, data)


# def get_fre_multi_timing(device_id, screen_id, refresh):
#     rs = read_detail_middle(device_id, screen_id)
#     if rs['status'] == 0:
#         tio_rs = open_output_middle.two_in_one_outputs_middle(device_id)
#         if tio_rs['status'] != 0:
#             return get_result_model(ResInfo.Screen_TwoInOneCard_Err)
#         tio_outputs = tio_rs['data']
#         timings = []
#         slots = []
#         for interface in rs['data']['outputMode']['screenInterfaces']:
#             if interface['outputId'] != 255:
#                 if interface['modelId'] not in ModelId.Two_In_One_Card_List:
#                     return get_result_model(ResInfo.Params_Error)
#                 if interface['modelId'] == ModelId.Output_Two_In_One_Card:
#                     category = CardCategory.TwoInOneCard
#                 else:
#                     category = CardCategory.TwoInOneCard_20
#                 rs = open_output_middle.output_original_detail_middle(
#                     device_id, interface['outputId'])
#                 if rs['status'] == 0:
#                     width = rs['data']['resolution']['width']
#                     height = rs['data']['resolution']['height']
#
#                     rs = open_output_middle.get_tio_output_timing_middle(
#                         category, width, height, refresh)
#                     if rs['status'] != 0:
#                         return rs
#                     outputs = tio_outputs[interface['slotId']]
#
#                     for x in outputs:
#                         timings.append({
#                             'deviceId': device_id,
#                             'outputId': x,
#                             'refreshRate': rs['data']['refreshRate'],
#                             'horizontal': copy.deepcopy(rs['data']['horizontal']),
#                             'vertical': copy.deepcopy(rs['data']['vertical'])
#                         })
#
#                     slots.append({
#                         'deviceId': device_id,
#                         'slotId': interface['slotId'],
#                         'resolution': {
#                             'width': width,
#                             'height': height,
#                             'refresh': refresh,
#                             'direction': rs['data'].get('direction', 0),
#                             'outputCount': rs['data'].get('outputCount', 4)
#                         }
#                     })
#                     rs['data'] = {
#                         'timings': timings,
#                         'slots': slots
#                     }
#                 else:
#                     return get_result_model(ResInfo.Output_Read_Error)
#     return rs

# def screen_delete_batch_middle(device_id, model, screen_id_list):
#     """
#     删除屏幕业务处理
#     :param device_id: 设备Id
#     :param screen_id:  屏幕Id
#     :return: 结果数据
#     """
#     screen_rs = screen_read_all_list_middle(device_id)
#     if screen_rs['status'] != 0:
#         return get_result_model(ResInfo.Middle_Data_Err)
#     del_list = []
#     if model == 1:
#         del_list = screen_id_list
#     else:
#         del_list = [x['screenId'] for x in screen_rs['data']]
#     poll_screen = [s['screenId'] for s in screen_rs['data'] if s['presetPoll']['enable'] == 1]
#     tio_screen = [s for s in screen_rs['data'] if s['screenType'] == 1 and s['freMultiEn'] == 1]
#     del_rs = []
#     for s_id in del_list:
#         if s_id in poll_screen:
#             del_rs.append({
#                 'deviceId': device_id,
#                 'screenId': s_id,
#                 'status': ResInfo.Screen_Is_Preset_Polling.value
#             })
#         else:
#             slots = timings = None
#             screen_data = [x for x in tio_screen if x['screenId'] == s_id]
#             if screen_data:
#                 screen_data = screen_data[0]
#                 refresh = screen_data['freMultiOut'] / screen_data['freMultiNum']
#                 frs = get_fre_multi_timing(device_id, s_id, refresh)
#                 if frs['status'] == 0:
#                     timings = frs['data']['timings']
#                     slots = frs['data']['slots']
#             d_rs = screen_delete(device_id, s_id)
#             if d_rs['status'] == 0:
#                 if timings and slots:
#                     set_fre_multi_timing(device_id, timings, slots)
#             del_rs.append({
#                 'deviceId': device_id,
#                 'screenId': s_id,
#                 'status': d_rs['status']
#             })
#             rs = get_result_model()
#             rs['data'] = del_rs
#
#             for s in [x for x in del_rs if x['status'] == 0]:
#                 open_layer_middle.delete_lock_by_screen(device_id, s)  # 清空所有图层锁
#
#             return jsonify(rs)


# def screen_delete(device_id, screen_id):
#     """
#     删除屏幕
#     :param device_id: 设备Id
#     :param screen_id:  屏幕Id
#     :return: 结果数据
#     """
#     data = {'deviceId': device_id, 'screenId': screen_id}
#     rs = screen_api.write_delete(device_id, screen_id, data)
#     if rs["status"] == 0:
#         logger.debug(
#             "删除screenDelete_write-成功,deviceId:%i, screenId:%i" %
#             (device_id, screen_id))
#     else:
#         logger.error(
#             "删除screenDelete_write-失败,deviceId:%i, screenId:%i, status:%i" %
#             (device_id, screen_id, rs["status"]))
#     return rs


def write_freeze_middle(device_id, screen_id, params):
    """
    屏幕设置freeze(ftb与freeze互斥)
    :param device_id:  设备Id
    :param screen_id:  屏幕Id
    :param params: ftb数据
    :return: 结果对象
    """
    return screen_api.write_freeze(device_id, screen_id, params)


def write_ftb_middle(device_id, screen_id, params):
    """
    屏幕设置ftb(ftb与freeze互斥)
    :param device_id:  设备Id
    :param screen_id:  屏幕Id
    :param params: ftb数据
    :return: 结果对象
    """
    return screen_api.write_ftb(device_id, screen_id, params)


def screen_bkg_write_middle(device_id, screen_id, params):
    """
    屏幕写bkg
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param params: 参数
    :return: 结果数据
    """
    return screen_api.write_bkg(device_id, screen_id, params)


def write_osd_middle(device_id, screen_id, data):
    """
     设置屏幕osd
     :param device_id: 设备id
     :param screen_id: 屏幕id
     :param data:
     :return: 结果对象
     """
    return screen_api.write_osd_and_handle_limit(device_id, screen_id, data)


def screen_non_time_detail_middle(device_id, screen_id):
    """
    读取非实时上屏全部数据
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :return: 结果对象
    """
    return screen_api.read_nontime_detail(device_id, screen_id)


def screen_no_time_play_middle(device_id, screen_id, data):
    """
    屏幕非实时上屏take
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param data: 图层数据
    :return: 结果对象
    """
    return screen_api.write_notime_play(device_id, screen_id, data)


def screen_screen_write_3d_middle(device_id, screen_id, data):
    """
    设置屏幕3D
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param data: 3D数据
    :return: 结果对象
    """
    return screen_api.write_screen_3d(device_id, screen_id, data)


def screen_write_gamma_middle(device_id, screen_id, data):
    return screen_api.write_gamma(device_id, screen_id, data)


def screen_write_output_mode_middle(device_id, screen_id, data):
    """
    设置屏幕布局
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param data: 布局数据，参考前端接口文档
    :return: 结果数据
    """
    return screen_api.write_output_mode(device_id, screen_id, data)


def screen_read_detail_middle(device_id, screen_id):
    """
    读取屏幕详细信息
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :return: 屏幕详细信息
    """
    st = time.time()  # 返回当前时间的时间戳（1970纪元后经过的浮点秒数）
    rs = read_detail_middle(device_id, screen_id)
    if rs["status"] == 0 and rs['data']:
        for output in rs['data']['outputMode']['screenInterfaces']:
            if 'dotpitch' not in output:
                output['dotpitch'] = 2
        if 'Osd' not in rs['data']:
            rs['data']['Osd'] = {'enable': 0}
        if 'OsdImage' not in rs['data']:
            rs['data']['OsdImage'] = {'enable': 0}
        else:
            file_path, file_url = screen_osd_manager.get_osd_path_info(
                rs['data']['OsdImage']['image']['file']['fileName'])
            rs['data']['OsdImage']['image']['file']['fileName'] = file_url
        # 大屏亮度，默认值-1不设置
        rs['data']['screenBrightness'] = -1
        # 二合一卡接口则读取屏幕亮度值
        if len([x for x in rs['data']['outputMode']['screenInterfaces']
                if x['modelId'] in ModelId.Two_In_One_Card_List]) > 0:
            rs['data']['screenBrightness'] = 0
            # 亮度数据
            brightness_rs = read_screen_brightness_middle(device_id, screen_id)
            if brightness_rs['status'] == 0:
                rs['data']['screenBrightness'] = brightness_rs['data']['brightness']

    else:
        logger.error(
            "screenFullDetail查询失败! screenId:%i, status:%i" %
            (screen_id, rs["status"]))

    et = time.time()  # 返回当前时间的时间戳（1970纪元后经过的浮点秒数）
    logger.debug("读取屏幕详情耗时(秒)：%s" % str(et - st))
    return rs


def screen_clear_layers_middle(device_id, screen_id):
    """
    清空屏幕图层
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :return: 结果对象
    """
    return screen_api.write_screen_clear_layers(
        device_id, screen_id, {
            'deviceId': device_id, 'screenId': screen_id})


def screen_write_image_osd_middle(device_id, screen_id, data):
    """
    设置屏幕osd
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
     :param data:
    :return: 结果对象
    """
    return screen_api.write_osd(device_id, screen_id, data)


def osd_read(device_id, screen_id):
    """
    屏幕读osd
    :param device_id: device_id
    :param screen_id:screen_id
    :return: 结果对象
    """
    rs = screen_api.read_osd(device_id, screen_id)
    return rs

def osd_write(device_id, screen_id, params):
    """
    屏幕写osd
    :param device_id: device_id
    :param screen_id:screen_id
    :param params: params
    :param has_file: has_file
    :return: 结果对象
    """
    # 0：文字；1：图片
    rs = screen_api.write_osd_and_handle_limit(device_id, screen_id, params)
    return rs

def write_screen_brightness(device_id, screen_id, data):
    return screen_api.write_screen_brightness(device_id, screen_id, data)


def screen_brightness_save(device_id, screen_id, data):
    return screen_api.save_screen_brightness(device_id, screen_id, data)