"""
Created on 2021年9月13日
@author: 程声清
layer业务处理层.
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U import get_result_model
from H_9U.mao.layer_mao import layer_api


# def layer_read_lock_middle(device_id, screen_id, layer_id, non_time):
#     """
#     读取图层锁定数据
#     :param device_id: 设备Id
#     :param screen_id:  屏幕Id
#     :param layer_id:  图层Id
#     :param non_time:
#     :return:  结果数据{'lock': 1}
#     """
#     key = str(device_id) + '|' + str(screen_id) + \
#         '|' + str(layer_id) + '|' + str(non_time)
#     rs = model_conf_dao.get_value(ModelConfKey.LayerLock, key)
#     value = 0
#     if rs['status'] == 0 and rs['data']['value'] >= 0:
#         value = rs['data']['value']
#     rs = get_result_model()
#     rs['data']['lock'] = value
#     return rs


def layer_write_lock_middle(device_id, screen_id, layer_id, is_lock):
    """
    设置图层锁定
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param layer_id: 图层Id
    :param is_lock: 是否锁定
    :return:
    """
    # key = str(device_id) + '|' + str(screen_id) + \
    #     '|' + str(layer_id) + '|' + str(non_time)
    # return model_conf_dao.set_value(ModelConfKey.LayerLock, key, is_lock)
    return layer_api.write_lock(device_id, screen_id, layer_id, {
        'deviceId': device_id,
        'screenId': screen_id,
        'layerId': layer_id,
        'lock': is_lock
    })

# def layer_delete_lock_by_screen_middle(device_id, screen_id):
#     """
#     删除屏幕锁
#     :param device_id: 设备 id
#     :param screen_id: 屏幕id
#     """
#     key = str(device_id) + '|' + str(screen_id) + '|'
#     return model_conf_dao.delete_value_by_prefix(ModelConfKey.LayerLock, key)


def layer_full_detail_list_middle(device_id, screen_id):
    """
    读取屏幕详细信息列表
    :param device_id:  设备id
    :param screen_id: 屏幕Id
    :return: list数组，元素同详细信息
    """
    rs = layer_api.read_list(device_id, screen_id)
    detail_list = []
    if rs['status'] == 0 and rs['data']:
        layers = rs['data']['screenLayers']
        for layer in layers:
            layer_id = layer['layerId']
            rs = layer_api.read_detail(device_id, screen_id, layer_id)
            if rs['status'] == 0 and rs['data']:
                # lock_rs = layer_read_lock_middle(
                #     device_id, screen_id, layer_id, 0)
                # lock = 0
                # if lock_rs['status'] == 0:
                #     lock = lock_rs['data']['lock']
                # rs['data']['lock'] = {"lock": lock}
                detail_list.append(rs['data'])
    rs = get_result_model()
    rs['data'] = {
        "screenId": screen_id,
        "deviceId": device_id,
        "screenLayers": detail_list
    }
    return rs


def layer_write_create_middle(device_id, screen_id, data):
    """
    创建图层
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :param data: 中间件协议文档LayerCreate
    :return: {'id':0, 'layersZOrder':[xxx]}
    """
    return layer_api.write_create(device_id, screen_id, data)


def layer_write_delete_middle(device_id, screen_id, layer_id, data):
    """
    删除图层
    清除全部缓存
    :param device_id: 设备id
    :param screen_id: 屏幕id
    :param layer_id: 图层id
    :param data:
    :return: 结果对象
    """
    return layer_api.write_delete(device_id, screen_id, layer_id, data)


def layer_read_detail_middle(device_id, screen_id, layer_id):
    """
    读取图层详细信息
    :param device_id: 设备id
    :param screen_id: 屏幕id
    :param layer_id: 图层id
    :return: 结果对象
    """
    return layer_api.read_detail(device_id, screen_id, layer_id)


def layer_general_write_middle(device_id, screen_id, layer_id, data):
    """
       读取图层基本信息
       :param device_id: 设备Id
       :param screen_id: 屏幕id
       :param layer_id: 图层号
       :param data: 参考中间件接口协议
       :return: 标准返回
       """
    return layer_api.write_general(device_id, screen_id, layer_id, data)


def layer_read_z_index_middle(device_id, screen_id):
    """
    设置图层source 信息
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :return: 参考中间件协议
    """
    return layer_api.read_zorder(device_id, screen_id)


def layer_write_layout_window_middle(device_id, screen_id, layer_id, data):
    """
    设置图层窗口信息
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :param layer_id: 图层号
    :param data: 参考中间件接口协议
    :return: 标准返回
    """
    return layer_api.write_layout_window(device_id, screen_id, layer_id, data)


def layer_write_z_index_middle(device_id, screen_id, data):
    """
    设置图层Z序
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :param data: 参考中间件接口协议
    :return: 参考中间件协议
    """
    return layer_api.write_zorder(device_id, screen_id, data)


def layer_write_source_middle(device_id, screen_id, layer_id, data):
    """
    设置图层source 信息
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :param layer_id: 图层号
    :param data: 参考中间件接口协议
    :return: 标准返回
    """
    return layer_api.write_source(device_id, screen_id, layer_id, data)


def layer_freeze_middle(device_id, screen_id, layer_id, data):
    """
    屏幕图层上屏
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param layer_id: 图层id
    :param data: 参考中间件接口协议
    :return: 结果对象
    """
    return layer_api.write_freeze(device_id, screen_id, layer_id, data)


def write_screen_layer_layout_middle(device_id, screen_id, data):
    """
    屏幕图层自动布局（模板开窗）
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param data: 图层数据
    :return: 结果对象
    """
    return layer_api.write_screen_layer_layout(device_id, screen_id, data)


def write_layer_stream_rule(device_id, data):
    """
    屏幕图层自动布局（模板开窗）
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param data: 图层数据
    :return: 结果对象
    """
    return layer_api.write_layer_stream_rule(device_id, data)
