"""
Created on 2024年3月1日
@author: 程声清
ndi接口.
对应接口ndi_mao
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
import math

from H_9U.util.cache import cacher
from H_9U.mao.impl import ndi


class NdiApi:
    def write_ndi_source_create(self, device_id, data):
        """
        创建ndi源
        :param device_id: 设备id
        :param data: 源信息
        :return: 源id
        """
        rs = ndi.ndi_source_create(device_id, data)
        if rs['status'] == 0:
            cacher.NdiCache.clear()
        return rs

    def write_ndi_source_delete(self, device_id, data):
        """
        创建ndi源
        :param device_id: 设备id
        :param data: 源信息
        :return: 源id
        """
        rs = ndi.ndi_source_delete(device_id, data)
        if rs['status'] == 0:
            cacher.NdiCache.clear()
        return rs

    def write_ndi_source_update(self, device_id, data):
        """
        创建ndi源
        :param device_id: 设备id
        :param data: 源信息
        :return: 源id
        """
        rs = ndi.ndi_source_update(device_id, data)
        if rs['status'] == 0:
            cacher.NdiCache.clear()
            cacher.LayerCache.clear()
        return rs

    def read_ndi_source_list(self, device_id, data):
        """
        创建ndi源
        :param device_id: 设备id
        :param data: 源信息
        :return: 源id
        """
        rs = ndi.ndi_source_list(device_id, data)
        if rs['status'] != 0 or rs['data']['sourceList'] or rs['data']['nums'] == 0:
            return rs
        data['seqPageIndex'] = math.ceil(rs['data']['nums'] / data['seqPageSize']) - 1
        return ndi.ndi_source_list(device_id, data)


    def read_ndi_source_search(self, device_id, source_mode):
        """
        创建ndi源
        :param device_id: 设备id
        :param data: 源信息
        :return: 源id
        """
        return ndi.ndi_source_search(device_id, source_mode)

    def read_ndi_source_detail(self, device_id, source_id):
        """
        创建ndi源
        :param device_id: 设备id
        :param data: 源信息
        :return: 源id
        """
        rs = ndi.ndi_source_detail(device_id, source_id)
        return rs

    def write_ndi_source_crop_create(self, device_id, input_id, data):
        """
        创建ndi源
        :param device_id: 设备id
        :param data: 源信息
        :return: 源id
        """
        rs = ndi.ndi_source_crop_create(device_id, input_id, data)
        if rs['status'] == 0:
            cacher.NdiCache.clear()
        return rs

    def write_ndi_source_crop_delete(self, device_id, data):
        """
        创建ndi源
        :param device_id: 设备id
        :param data: 源信息
        :return: 源id
        """
        rs = ndi.ndi_source_crop_delete(device_id, data)
        if rs['status'] == 0:
            cacher.clear_all()
        return rs

    def write_ndi_source_crop_update(self, device_id, input_id, crop_id, data):
        """
        创建ndi源
        :param device_id: 设备id
        :param data: 源信息
        :return: 源id
        """
        rs = ndi.ndi_source_crop_update(device_id, input_id, crop_id, data)
        if rs['status'] == 0:
            cacher.clear_all()
        return rs

    def read_ndi_source_crop_list(self, device_id, source_id, source_type):
        """
        创建ndi源
        :param device_id: 设备id
        :param data: 源信息
        :return: 源id
        """
        return ndi.ndi_source_crop_list(device_id, source_id, source_type)

    def ndi_stream_detail(self, device_id, data):
        return ndi.ndi_stream_detail(device_id, data)

    def ndi_stream_list(self, device_id):
        return ndi.ndi_stream_list(device_id)


ndi_api = NdiApi()