"""
Created on 2024年3月1日
@author: 程声清
ndi接口.
对应前端接口ndi_mao_impl
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.protocol.fncode import FnCode
from H_9U.models.result import transfer_midware_resp
from H_9U import controller as ctrl
from H_9U.util.logwrapper import log_wrapper


@log_wrapper
def ndi_source_create(device_id, data):
    """
    创建ndi源
    :param device_id: 设备id
    :param data: 源信息
    :return: 源id
    """
    return transfer_midware_resp(ctrl.write(FnCode.NDI_SOURCE_CREATE, data, device_id))


@log_wrapper
def ndi_source_delete(device_id, data):
    """
    删除ndi源
    :param device_id: 设备id
    :param data: 源信息
    :return: 源id
    """
    return transfer_midware_resp(ctrl.write(FnCode.NDI_SOURCE_DELETE, [data], device_id))


@log_wrapper
def ndi_source_update(device_id, data):
    """
    编辑ndi源
    :param device_id: 设备id
    :param data: 源信息
    :return: 源id
    """
    return transfer_midware_resp(ctrl.write(FnCode.NDI_SOURCE_UPDATE, [data], device_id))


@log_wrapper
def ndi_source_list(device_id, data):
    """
    编辑ndi源
    :param device_id: 设备id
    :return: 源id
    """
    return transfer_midware_resp(ctrl.write(FnCode.NDI_SOURCE_LIST, [data], device_id))


@log_wrapper
def ndi_source_search(device_id, sourceMede):
    """
    编辑ndi源
    :param device_id: 设备id
    :return: 源id
    """
    return transfer_midware_resp(ctrl.read(FnCode.NDI_SOURCE_SEARCH, device_id, sourceMede))


@log_wrapper
def ndi_source_detail(device_id, source_id):
    """
    编辑ndi源
    :param device_id: 设备id
    :return: 源id
    """
    return transfer_midware_resp(ctrl.read(FnCode.NDI_SOURCE_UPDATE, device_id, source_id))


@log_wrapper
def ndi_source_crop_create(device_id, input_id, data):
    """
    编辑ndi源
    :param device_id: 设备id
    :param data: 源信息
    :return: 源id
    """
    return transfer_midware_resp(ctrl.write(FnCode.NDI_SOURCE_CROP_CREATE, [data], device_id, input_id))


@log_wrapper
def ndi_source_crop_delete(device_id, data):
    """
    编辑ndi源
    :param device_id: 设备id
    :param data: 源信息
    :return: 源id
    """
    return transfer_midware_resp(ctrl.write(FnCode.NDI_SOURCE_CROP_DELETE, [data], device_id))


@log_wrapper
def ndi_source_crop_update(device_id, input_id, crop_id, data):
    """
    编辑ndi源
    :param device_id: 设备id
    :param data: 源信息
    :return: 源id
    """
    return transfer_midware_resp(ctrl.write(FnCode.NDI_SOURCE_CROP_UPDATE, [data], device_id, input_id, crop_id,))


@log_wrapper
def ndi_source_crop_list(device_id, source_id, source_type):
    """
    编辑ndi源
    :param device_id: 设备id
    :param data: 源信息
    :return: 源id
    """
    # Id低字节
    source_id_low = source_id % 256
    # Id高字节
    source_id_high = source_id // 256
    return transfer_midware_resp(ctrl.read(FnCode.NDI_SOURCE_CROP_LIST, device_id, source_id_low, source_id_high, source_type))

@log_wrapper
def ndi_stream_detail(device_id, data):
    return transfer_midware_resp(ctrl.write(FnCode.NDI_STREAM_DETAIL, [data], device_id))


@log_wrapper
def ndi_stream_list(device_id):
    return transfer_midware_resp(ctrl.read(FnCode.NDI_STREAM_LIST, device_id))
