"""
@Project ：h_series 
@File    ：log.py
@IDE     ：PyCharm 
@Author  ：程声清
@Date    ：2023/5/4 11:15 
"""
import datetime
from H_9U import get_result_model, ResInfo
from H_9U.util.logwrapper import log_wrapper
from sqlite3 import IntegrityError

from H_9U.util.sqlitepool import pool, sqllock
from H_9U.models.result import get_result_model, ResInfo
from H_9U.util.log import logger

class LogDao:
    def __init__(self, conn_pool):
        self.pool = conn_pool

    def format_end_date(self, end):
        """
        格式化结束时间，时间上加1天
        """
        try:
            if end:
                end = datetime.datetime.strptime(end, '%Y-%m-%d')
                end += datetime.timedelta(days=1)
                return end.strftime('%Y-%m-%d')
        except Exception as e:
           pass

    @log_wrapper
    def paged_log_list(self, type, log_module,  index, size, begin, end, sort_mode):
        """
        分页获取日志信息
        """
        rs = get_result_model()
        if index > 0:
            index -= 1
        end = self.format_end_date(end)
        args = []
        sql = " where type = ? "
        args.append(type)
        if log_module is not None:
            sql += ' and log_module =? '
            args.append(log_module)
        if begin:
            sql += " and log_time>=? "
            args.append(begin)
        if end:
            sql += " and log_time <? "
            args.append(end)
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute('select count(1) as total from sys_log ' + sql, args)
                total = cursor.fetchone()[0]
                base_sql = "select id, type, ip, log_time, log_module, function, operation, message, username, userid, client from sys_log "
                order_asl = " order by id limit ? offset ? "
                args.append(size)
                args.append( index * size)
                query_sql = base_sql + sql + order_asl
                cursor.execute(query_sql, args)
                rows = cursor.fetchall()
                log_list = []
                if rows:
                    for row in rows:
                        log_list.append({
                            'id': row[0],
                            'type': row[1],
                            'ip': row[2],
                            'log_time': row[3],
                            'log_module': row[4],
                            'function': row[5],
                            'operation': row[6],
                            'message': row[7],
                            'username': row[8],
                            'userid': row[9],
                            'client': row[10]
                        })
                rs['data'] = {
                    "totalCount": total,
                    "logs": log_list
                }
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs


    @log_wrapper
    def delete_log_list(self, log_type, begin, end):
        rs = get_result_model()
        end = self.format_end_date(end)
        try:
            sqllock.acquire()
            conn = self.pool.get()
            sql = 'delete from sys_log '
            args = []
            cons = []
            if log_type:
                cons.append('type=?')
                args.append(log_type)
            if begin:
                cons.append("log_time>=?")
                args.append(begin)
            if end:
                cons.append("log_time<?")
                args.append(end)
            if cons:
                sql += ' where ' + ' and '.join(cons)
            with conn:
                cursor = conn.cursor()
                cursor.execute(sql, args)
                conn.commit()
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def add(self, type, ip, log_module, function, operation, message, user_name, user_id, client):
        """
        添加日志
        """
        rs = get_result_model()
        log_time = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        try:
            sqllock.acquire()
            conn = self.pool.get()
            sql = 'insert into sys_log (type, ip, log_time, log_module, function, operation, message, username, userid, client) ' \
                  'values(?,?,?,?,?,?,?,?,?,?)'
            args = (type, ip, log_time, log_module, function, operation, message, user_name, user_id, client)
            with conn:
                cursor = conn.cursor()
                cursor.execute(sql, args)
                conn.commit()
        except Exception as e:
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

logdao = LogDao(pool)