"""
Created on 2019年6月28日
@author: 刘益宗
webSender接口.
对应前端推送接口文档websender
"""
import threading
from queue import Queue

from flask import g

from H_9U.util.log import logger
from H_9U.api.websocket import message_send, clear_clients


org_queue = Queue()
func_queue = Queue()

org_thread = None
func_thread = None


class PushThread(threading.Thread):
    """
    推送线程类
    """
    def __init__(self):
        """
        构造函数
        :param func: 回调函数
        :param user:  用户
        :param token:  token
        :param name:  接口name
        :param args:  回调函数参数
        :param kwargs: 回调函数参数
        """
        threading.Thread.__init__(self)

    def run(self):
        # 加入当前app作用域
        from H_9U import app
        with app.app_context():
            while not func_queue.empty():
                func, user, token, name, args, kwargs = func_queue.get()
                try:
                    g.token = token
                    res = func(*args, **kwargs)
                    if res['status'] == 0:
                        # 组包
                        data = {
                            'user': user,
                            'name': name,
                            'data': res['data'],
                            'token': token
                        }
                        # 推送
                        add_org(data)
                except Exception as e:
                    logger.error(e)
        global func_thread
        func_thread = None


class PushOrgThread(threading.Thread):
    """
    推送线程类
    """
    def __init__(self):
        """
        构造函数
        :param func: 回调函数
        :param user:  用户
        :param token:  token
        :param name:  接口name
        :param args:  回调函数参数
        :param kwargs: 回调函数参数
        """
        threading.Thread.__init__(self)

    def run(self):
        while not org_queue.empty():
            data = org_queue.get()
            try:
                # 推送
                # threading.Thread(target=message_send, args=(data,)).start()
                message_send(data)
            except Exception as e:
                logger.error(e)
        global org_thread
        org_thread = None


def add_func(func, user, token, name, *args, **kwargs):
    # logger.info('add to func queue')
    global func_queue
    func_queue.put((func, user, token, name, args, kwargs))
    global func_thread
    if not func_thread:
        func_thread = PushThread()
        func_thread.start()


def add_org(data):
    # logger.info('add to org queue')
    global org_queue
    org_queue.put(data)
    global org_thread
    if not org_thread:
        org_thread = PushOrgThread()
        org_thread.start()


def push_data_org(name, biz_data):
    """
    直接推送业务数据
    :param name: 接口推送name
    :param biz_data: 业务数据
    :return: 无
    """
    try:
        user = g.user['username']
        token = g.token
        data = {
            'user': user,
            'token': token,
            'name': name,
            'data': biz_data
        }
        add_org(data)
    except Exception as e:
        logger.error('推送数据出现问题：%s' % str(e))


def push_data(func, name, *args, **kwargs):
    """
    推送数据
    :param func: 回调函数
    :param name:  接口name
    :param args:  回调函数参数
    :param kwargs: 回调函数参数
    :return:  无
    """
    try:
        user = g.user['username']
        token = g.token
        # 启动新线程操作推送
        add_func(func, user, token, name, *args, **kwargs)
    except Exception as e:
        logger.error('推送数据出现问题：%s' % str(e))


def push_by_upload(func, user, token, name, *args, **kwargs):
    """
    主动上报推送函数
    :param func:  回调函数
    :param user:  用户
    :param token:  token
    :param name:  接口name
    :param args:  回调函数参数
    :param kwargs: 回调函数参数
    :return:  无
    """
    try:
        add_func(func, user, token, name, *args, **kwargs)
    except Exception as e:
        logger.error('推送数据出现问题：%s' % str(e))


def push_org_by_upload(user, token, name, data):
    """
    主动上报推送函数
    :param user:  用户
    :param token:  用户token
    :param name:  接口Name
    :param data:  推送数据
    :return: 无
    """
    data = {
        'user': user,
        'token': token,
        'name': name,
        'data': data
    }
    add_org(data)


def clear_push_data():
    try:
        global org_queue
        org_queue.queue.clear()
        clear_clients()
        global org_thread
        org_thread = None
        global func_thread
        func_thread = None
    except Exception as e:
        logger.error('*'*100)
        logger.exception(e)