#!/bin/sh

### BEGIN INIT INFO
# Provides:          
# Required-Start:     
# Required-Stop:      
# Default-Start:     5
# Default-Stop:       
# Short-Description:  
# Description:        
### END INIT INFO

if [ -f /usr/Hseries/bin/log.sh ]; then
	. /usr/Hseries/bin/log.sh
else 
	log_info()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
	log_debug()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
	log_error()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
fi

log_info "insmod-drvs $1"

if [ $1 != "start" ]; then
	log_info "insmod-drvs don't run"
	exit 0
fi

NOVA_DRIVER_PATH=/usr/nova/driver_nova

check_fpga_load()
{
    cnt_min=1
    cnt_max=3
    id=$1
    file=$2
    while [ $cnt_min -lt $cnt_max ];
    do
	sleep 2
	fpgacfg=$(/bin/cat /proc/fpga_cfg${id}/cfg_result)
        if [ $fpgacfg = "0" ]; then
                echo "fpga config ok!"
                break
        fi
	/usr/nova/sbin/fpga_load $id /usr/nova/etc/fpga/$file
        sleep 1
        cnt_min=`expr $cnt_min + 1`
    done
    if [ $cnt_min -eq $cnt_max ]; then
        echo "fpga config error!"
    fi

}

ins_lcd_drv()
{
	device_type=`cat /proc/chassis_info/model_id`
	if [ $device_type = "4" ]; then  
#H2增加tft驱动加载		
    echo 1188 > /sys/class/gpio/export
    echo out > /sys/class/gpio/gpio1188/direction
    echo 1 > /sys/class/gpio/gpio1188/value
	insmod ${NOVA_DRIVER_PATH}/nova-hseries-fbtft.ko gpios=reset:1149,dc:1186 rotate=90
	echo "H2 device need insmod tft driver"
	else
	echo "Not H2 device"
	fi
}

check_hw_version()
{
	echo 1162 > /sys/class/gpio/export
	echo in > /sys/class/gpio/gpio1162/direction
       	cat /sys/class/gpio/gpio1162/value > /usr/Hseries/hw_version
	echo 1162 > /sys/class/gpio/unexport
}

echo "Starting insmod..."

#exit 0
check_hw_version

insmod ${NOVA_DRIVER_PATH}/nova-hseries-cpspi.ko
insmod ${NOVA_DRIVER_PATH}/nova-hseries-stub.ko
insmod ${NOVA_DRIVER_PATH}/nova-hseries-comif.ko
insmod ${NOVA_DRIVER_PATH}/nova-hseries-sysinit.ko
#insmod ${NOVA_DRIVER_PATH}/nova-hseries-fpga_cfg.ko
#check_fpga_load 0 main_ctrl_card_top.bin
#/usr/nova/sbin/fpga_load 0 /usr/Hseries/etc/fpga/main_ctrl_card_top.bin
insmod ${NOVA_DRIVER_PATH}/nova-hseries-i2cdev.ko
insmod ${NOVA_DRIVER_PATH}/nova-hseries-spidev.ko
insmod ${NOVA_DRIVER_PATH}/nova-hseries-rtc.ko
insmod ${NOVA_DRIVER_PATH}/nova-hseries-rtc_it7c4337.ko
insmod ${NOVA_DRIVER_PATH}/nova-hseries-fan.ko
#insmod ${NOVA_DRIVER_PATH}/nova-hseries-goodix.ko
insmod ${NOVA_DRIVER_PATH}/nova-hseries-uart_com.ko
insmod ${NOVA_DRIVER_PATH}/nova-hseries-multi_iocfg.ko
#insmod ${NOVA_DRIVER_PATH}/nova-hseries-adv76xx.ko

ins_lcd_drv


exit $?

